/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public class ToStringSerializer<T>
implements Serializer<T> {
    public static final String ADD_TYPE_INFO_HEADERS = "spring.message.add.type.headers";
    public static final String KEY_TYPE = "spring.message.key.type";
    public static final String VALUE_TYPE = "spring.message.value.type";
    private boolean addTypeInfo = true;
    private Charset charset = StandardCharsets.UTF_8;
    private String typeInfoHeader = "spring.message.value.type";

    public void configure(Map<String, ?> configs, boolean isKey) {
        if (isKey) {
            this.typeInfoHeader = KEY_TYPE;
        }
        if (configs.containsKey(ADD_TYPE_INFO_HEADERS)) {
            Object config = configs.get(ADD_TYPE_INFO_HEADERS);
            if (config instanceof Boolean) {
                this.addTypeInfo = (Boolean)config;
            } else if (config instanceof String) {
                this.addTypeInfo = Boolean.parseBoolean((String)config);
            } else {
                throw new IllegalStateException("spring.message.add.type.headers must be Boolean or String");
            }
        }
    }

    public byte[] serialize(String topic, @Nullable T data) {
        return this.serialize(topic, null, data);
    }

    public byte[] serialize(String topic, @Nullable Headers headers, @Nullable T data) {
        if (data == null) {
            return null;
        }
        if (this.addTypeInfo && headers != null) {
            headers.add(this.typeInfoHeader, data.getClass().getName().getBytes());
        }
        return data.toString().getBytes(this.charset);
    }

    public void close() {
    }

    public boolean isAddTypeInfo() {
        return this.addTypeInfo;
    }

    public void setAddTypeInfo(boolean addTypeInfo) {
        this.addTypeInfo = addTypeInfo;
    }

    public void setCharset(Charset charset) {
        Assert.notNull((Object)charset, (String)"'charset' cannot be null");
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }
}

