/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.kafka.streams.kstream.Branched;
import org.apache.kafka.streams.kstream.BranchedKStream;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Predicate;
import org.jspecify.annotations.Nullable;

public final class KafkaStreamBrancher<K, V> {
    private final List<Predicate<? super K, ? super V>> predicateList = new ArrayList<Predicate<? super K, ? super V>>();
    private final List<Consumer<? super KStream<K, V>>> consumerList = new ArrayList<Consumer<? super KStream<K, V>>>();
    private @Nullable Consumer<? super KStream<K, V>> defaultConsumer;

    public KafkaStreamBrancher<K, V> branch(Predicate<? super K, ? super V> predicate, Consumer<? super KStream<K, V>> consumer) {
        this.predicateList.add(Objects.requireNonNull(predicate));
        this.consumerList.add(Objects.requireNonNull(consumer));
        return this;
    }

    public KafkaStreamBrancher<K, V> defaultBranch(Consumer<? super KStream<K, V>> consumer) {
        this.defaultConsumer = Objects.requireNonNull(consumer);
        return this;
    }

    public KStream<K, V> onTopOf(KStream<K, V> stream) {
        if (this.defaultConsumer != null) {
            this.predicateList.add((k, v) -> true);
            this.consumerList.add(this.defaultConsumer);
        }
        if (this.predicateList.size() != this.consumerList.size()) {
            throw new IllegalStateException("Number of predicates (" + this.predicateList.size() + ") must match number of consumers (" + this.consumerList.size() + ")");
        }
        BranchedKStream branchedKStream = stream.split();
        Iterator<Consumer<KStream<K, V>>> consumerIterator = this.consumerList.iterator();
        for (Predicate<? super K, ? super V> predicate : this.predicateList) {
            branchedKStream = branchedKStream.branch(predicate, Branched.withConsumer(this.adaptConsumer(consumerIterator.next())));
        }
        return stream;
    }

    private Consumer<KStream<K, V>> adaptConsumer(Consumer<? super KStream<K, V>> consumer) {
        return consumer::accept;
    }
}

