/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Utils;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.support.serializer.SerializationUtils;
import org.springframework.util.Assert;

public class ParseStringDeserializer<T>
implements Deserializer<T> {
    public static final String KEY_PARSER = "spring.message.key.parser";
    public static final String VALUE_PARSER = "spring.message.value.parser";
    private static final BiFunction<String, Headers, ?> NO_PARSER = (str, headers) -> {
        throw new IllegalStateException("A parser must be provided either via a constructor or consumer properties");
    };
    private BiFunction<String, Headers, T> parser = NO_PARSER;
    private Charset charset = StandardCharsets.UTF_8;

    public ParseStringDeserializer() {
    }

    public ParseStringDeserializer(Function<String, T> parser) {
        this.parser = (message, ignoredHeaders) -> parser.apply((String)message);
    }

    public ParseStringDeserializer(BiFunction<String, Headers, T> parser) {
        this.parser = parser;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        if (NO_PARSER.equals(this.parser)) {
            String parserMethod = (String)configs.get(isKey ? KEY_PARSER : VALUE_PARSER);
            Assert.state((parserMethod != null ? 1 : 0) != 0, (String)"A parser must be provided either via a constructor or consumer properties");
            this.parser = SerializationUtils.propertyToMethodInvokingFunction(parserMethod, String.class, this.getClass().getClassLoader());
        }
    }

    public T deserialize(String topic, byte[] data) {
        return this.deserialize(topic, null, data);
    }

    public T deserialize(String topic, @Nullable Headers headers, byte[] data) {
        return this.parser.apply(data == null ? null : new String(data, this.charset), headers);
    }

    public T deserialize(String topic, Headers headers, ByteBuffer data) {
        String value = this.deserialize(data);
        return this.parser.apply(value, headers);
    }

    private @Nullable String deserialize(@Nullable ByteBuffer data) {
        if (data == null) {
            return null;
        }
        if (data.hasArray()) {
            return new String(data.array(), data.position() + data.arrayOffset(), data.remaining(), this.charset);
        }
        return new String(Utils.toArray((ByteBuffer)data), this.charset);
    }

    public void setCharset(Charset charset) {
        Assert.notNull((Object)charset, (String)"'charset' cannot be null");
        this.charset = charset;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public BiFunction<String, Headers, T> getParser() {
        return this.parser;
    }
}

