/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.converter;

import java.lang.reflect.Type;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.utils.Bytes;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.mapping.DefaultJacksonJavaTypeMapper;
import org.springframework.kafka.support.mapping.JacksonJavaTypeMapper;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.JacksonJsonMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.type.TypeFactory;

public class MappingJacksonJsonParameterizedConverter
extends JacksonJsonMessageConverter {
    private static final JavaType OBJECT = TypeFactory.createDefaultInstance().constructType(Object.class);
    private JacksonJavaTypeMapper typeMapper = new DefaultJacksonJavaTypeMapper();

    public MappingJacksonJsonParameterizedConverter() {
    }

    public MappingJacksonJsonParameterizedConverter(MimeType ... supportedMimeTypes) {
        super(supportedMimeTypes);
    }

    public JacksonJavaTypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public void setTypeMapper(JacksonJavaTypeMapper typeMapper) {
        Assert.notNull((Object)typeMapper, (String)"'typeMapper' cannot be null");
        this.typeMapper = typeMapper;
    }

    protected @Nullable Object convertFromInternal(Message<?> message, Class<?> targetClass, @Nullable Object conversionHint) {
        JavaType javaType = this.determineJavaType(message, conversionHint);
        Object value = message.getPayload();
        if (value instanceof Bytes) {
            Bytes bytesValue = (Bytes)value;
            value = bytesValue.get();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            try {
                return this.getJsonMapper().readValue(stringValue, javaType);
            }
            catch (Exception e) {
                throw new ConversionException("Failed to convert from JSON", message, (Throwable)e);
            }
        }
        if (value instanceof byte[]) {
            byte[] byteArrayValue = (byte[])value;
            try {
                return this.getJsonMapper().readValue(byteArrayValue, javaType);
            }
            catch (Exception e) {
                throw new ConversionException("Failed to convert from JSON", message, (Throwable)e);
            }
        }
        throw new IllegalStateException("Only String, Bytes, or byte[] supported");
    }

    private JavaType determineJavaType(Message<?> message, @Nullable Object hint) {
        JavaType javaType = null;
        Type type = null;
        if (hint instanceof Type) {
            type = (Type)hint;
            Headers nativeHeaders = (Headers)message.getHeaders().get((Object)"kafka_nativeHeaders", Headers.class);
            if (nativeHeaders != null) {
                JavaType javaType2 = javaType = this.typeMapper.getTypePrecedence().equals((Object)JacksonJavaTypeMapper.TypePrecedence.INFERRED) ? TypeFactory.createDefaultInstance().constructType(type) : this.typeMapper.toJavaType(nativeHeaders);
            }
        }
        if (javaType == null) {
            javaType = type != null ? TypeFactory.createDefaultInstance().constructType(type) : OBJECT;
        }
        return javaType;
    }
}

