/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.listener.KafkaExceptionLogLevelAware;
import org.springframework.kafka.support.ExceptionMatcher;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.serializer.DeserializationException;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.handler.invocation.MethodArgumentResolutionException;
import org.springframework.util.Assert;

public abstract class ExceptionClassifier
extends KafkaExceptionLogLevelAware {
    private ExtendedExceptionMatcher exceptionMatcher = ExceptionClassifier.configureDefaultClassifier(true);

    public static List<Class<? extends Throwable>> defaultFatalExceptionsList() {
        return Arrays.asList(DeserializationException.class, MessageConversionException.class, ConversionException.class, MethodArgumentResolutionException.class, NoSuchMethodException.class, ClassCastException.class);
    }

    private static ExtendedExceptionMatcher configureDefaultClassifier(boolean defaultClassification) {
        return new ExtendedExceptionMatcher(ExceptionClassifier.defaultFatalExceptionsList().stream().collect(Collectors.toMap(ex -> ex, ex -> false)), defaultClassification);
    }

    public void defaultFalse(boolean retainStandardFatal) {
        if (retainStandardFatal) {
            this.exceptionMatcher = ExceptionClassifier.configureDefaultClassifier(false);
        } else {
            this.defaultFalse();
        }
    }

    public void defaultFalse() {
        this.exceptionMatcher = new ExtendedExceptionMatcher(new HashMap<Class<? extends Throwable>, Boolean>(), false);
    }

    protected ExceptionMatcher getExceptionMatcher() {
        return this.exceptionMatcher;
    }

    public void setClassifications(Map<Class<? extends Throwable>, Boolean> classifications, boolean defaultValue) {
        Assert.notNull(classifications, (String)"'classifications' + cannot be null");
        this.exceptionMatcher = new ExtendedExceptionMatcher(classifications, defaultValue);
    }

    @SafeVarargs
    public final void addNotRetryableExceptions(Class<? extends Exception> ... exceptionTypes) {
        this.add(false, exceptionTypes);
        this.notRetryable(Arrays.stream(exceptionTypes));
    }

    protected void notRetryable(Stream<Class<? extends Exception>> notRetryable) {
    }

    @SafeVarargs
    public final void addRetryableExceptions(Class<? extends Exception> ... exceptionTypes) {
        this.add(true, exceptionTypes);
    }

    @SafeVarargs
    private void add(boolean classified, Class<? extends Exception> ... exceptionTypes) {
        Assert.notNull(exceptionTypes, (String)"'exceptionTypes' cannot be null");
        Assert.noNullElements((Object[])exceptionTypes, (String)"'exceptionTypes' cannot contain nulls");
        for (Class<? extends Exception> exceptionType : exceptionTypes) {
            Assert.isTrue((boolean)Exception.class.isAssignableFrom(exceptionType), () -> "exceptionType " + String.valueOf(exceptionType) + " must be an Exception");
            this.exceptionMatcher.getEntries().put(exceptionType, classified);
        }
    }

    public @Nullable Boolean removeClassification(Class<? extends Exception> exceptionType) {
        return this.exceptionMatcher.getEntries().remove(exceptionType);
    }

    private static final class ExtendedExceptionMatcher
    extends ExceptionMatcher {
        ExtendedExceptionMatcher(Map<Class<? extends Throwable>, Boolean> typeMap, boolean defaultValue) {
            super(typeMap, defaultValue, true);
        }

        @Override
        protected Map<Class<? extends Throwable>, Boolean> getEntries() {
            return super.getEntries();
        }
    }
}

