/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.time.Duration;
import org.apache.kafka.common.TopicPartition;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.listener.BackOffHandler;
import org.springframework.kafka.listener.DefaultBackOffHandler;
import org.springframework.kafka.listener.ListenerContainerPauseService;
import org.springframework.kafka.listener.MessageListenerContainer;

public class ContainerPausingBackOffHandler
implements BackOffHandler {
    private final DefaultBackOffHandler defaultBackOffHandler = new DefaultBackOffHandler();
    private final ListenerContainerPauseService pauser;

    public ContainerPausingBackOffHandler(ListenerContainerPauseService pauser) {
        this.pauser = pauser;
    }

    @Override
    public void onNextBackOff(@Nullable MessageListenerContainer container, @Nullable Exception exception, long nextBackOff) {
        if (container == null) {
            this.defaultBackOffHandler.onNextBackOff(container, exception, nextBackOff);
        } else {
            this.pauser.pause(container, Duration.ofMillis(nextBackOff));
        }
    }

    @Override
    public void onNextBackOff(MessageListenerContainer container, TopicPartition partition, long nextBackOff) {
        this.pauser.pausePartition(container, partition, Duration.ofMillis(nextBackOff));
    }
}

