/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.KafkaException;

public class BatchListenerFailedException
extends KafkaException {
    private static final long serialVersionUID = 1L;
    private final int index;
    private transient @Nullable ConsumerRecord<?, ?> record;

    public BatchListenerFailedException(String message, int index) {
        this(message, null, index);
    }

    public BatchListenerFailedException(String message, @Nullable Throwable cause, int index) {
        super(message, cause);
        this.index = index;
        this.record = null;
    }

    public BatchListenerFailedException(String message, ConsumerRecord<?, ?> record) {
        this(message, null, record);
    }

    public BatchListenerFailedException(String message, @Nullable Throwable cause, ConsumerRecord<?, ?> record) {
        super(message, cause);
        this.record = record;
        this.index = -1;
    }

    public @Nullable ConsumerRecord<?, ?> getRecord() {
        return this.record;
    }

    public int getIndex() {
        return this.index;
    }

    public String getMessage() {
        return super.getMessage() + " " + (this.record != null ? this.record.topic() + "-" + this.record.partition() + "@" + this.record.offset() : "@-" + this.index);
    }
}

