/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.ContainerAwareErrorHandler;
import org.springframework.kafka.listener.ListenerExecutionFailedException;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ConditionalDelegatingErrorHandler
implements ContainerAwareErrorHandler {
    private final ContainerAwareErrorHandler defaultErrorHandler;
    private final Map<Class<? extends Throwable>, ContainerAwareErrorHandler> delegates = new LinkedHashMap<Class<? extends Throwable>, ContainerAwareErrorHandler>();

    public ConditionalDelegatingErrorHandler(ContainerAwareErrorHandler defaultErrorHandler) {
        Assert.notNull((Object)defaultErrorHandler, (String)"'defaultErrorHandler' cannot be null");
        this.defaultErrorHandler = defaultErrorHandler;
    }

    public void setErrorHandlers(Map<Class<? extends Throwable>, ContainerAwareErrorHandler> delegates) {
        this.delegates.clear();
        this.delegates.putAll(delegates);
    }

    public void addDelegate(Class<? extends Throwable> throwable, ContainerAwareErrorHandler handler) {
        this.delegates.put(throwable, handler);
    }

    @Override
    public void handle(Exception thrownException, @Nullable List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        boolean handled = false;
        Throwable cause = thrownException;
        if (cause instanceof ListenerExecutionFailedException) {
            cause = thrownException.getCause();
        }
        if (cause != null) {
            Class<?> causeClass = cause.getClass();
            for (Map.Entry<Class<? extends Throwable>, ContainerAwareErrorHandler> entry : this.delegates.entrySet()) {
                if (!entry.getKey().isAssignableFrom(causeClass)) continue;
                handled = true;
                entry.getValue().handle(thrownException, records, consumer, container);
                return;
            }
        }
        this.defaultErrorHandler.handle(thrownException, records, consumer, container);
    }
}

