/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.streams;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Transformer;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.springframework.expression.Expression;

public class HeaderEnricher<K, V>
implements Transformer<K, V, KeyValue<K, V>> {
    private final Map<String, Expression> headerExpressions = new HashMap<String, Expression>();
    private ProcessorContext processorContext;

    public HeaderEnricher(Map<String, Expression> headerExpressions) {
        this.headerExpressions.putAll(headerExpressions);
    }

    public void init(ProcessorContext context) {
        this.processorContext = context;
    }

    public KeyValue<K, V> transform(K key, V value) {
        Headers headers = this.processorContext.headers();
        Container container = new Container(this.processorContext, key, value);
        this.headerExpressions.forEach((name, expression) -> {
            Object headerValue = expression.getValue((Object)container);
            if (headerValue instanceof String) {
                headerValue = ((String)headerValue).getBytes(StandardCharsets.UTF_8);
            } else if (!(headerValue instanceof byte[])) {
                throw new IllegalStateException("Invalid header value type: " + headerValue.getClass());
            }
            headers.add((Header)new RecordHeader(name, (byte[])headerValue));
        });
        return new KeyValue(key, value);
    }

    public void close() {
    }

    public static final class Container<K, V> {
        private final ProcessorContext context;
        private final K key;
        private final V value;

        private Container(ProcessorContext context, K key, V value) {
            this.context = context;
            this.key = key;
            this.value = value;
        }

        public ProcessorContext getContext() {
            return this.context;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

