/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.springframework.kafka.listener.BatchInterceptor;
import org.springframework.util.Assert;

public class CompositeBatchInterceptor<K, V>
implements BatchInterceptor<K, V> {
    private final Collection<BatchInterceptor<K, V>> delegates = new ArrayList<BatchInterceptor<K, V>>();

    @SafeVarargs
    public CompositeBatchInterceptor(BatchInterceptor<K, V> ... delegates) {
        Assert.notNull(delegates, (String)"'delegates' cannot be null");
        Assert.noNullElements((Object[])delegates, (String)"'delegates' cannot have null entries");
        this.delegates.addAll(Arrays.asList(delegates));
    }

    @Override
    public ConsumerRecords<K, V> intercept(ConsumerRecords<K, V> records) {
        ConsumerRecords<K, V> recordsToIntercept = records;
        for (BatchInterceptor<K, V> delegate : this.delegates) {
            recordsToIntercept = delegate.intercept(recordsToIntercept);
        }
        return recordsToIntercept;
    }

    @Override
    public void success(ConsumerRecords<K, V> records) {
        this.delegates.forEach(del -> del.success(records));
    }

    @Override
    public void failure(ConsumerRecords<K, V> records, Exception exception) {
        this.delegates.forEach(del -> del.failure(records, exception));
    }
}

