/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.xpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.xml.DefaultXmlPayloadConverter;
import org.springframework.integration.xml.XmlPayloadConverter;
import org.springframework.integration.xml.xpath.XPathEvaluationType;
import org.springframework.util.Assert;
import org.springframework.xml.DocumentBuilderFactoryUtils;
import org.springframework.xml.xpath.NodeMapper;
import org.springframework.xml.xpath.XPathException;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class XPathUtils {
    public static final String STRING = "string";
    public static final String BOOLEAN = "boolean";
    public static final String NUMBER = "number";
    public static final String NODE = "node";
    public static final String NODE_LIST = "node_list";
    public static final String DOCUMENT_LIST = "document_list";
    private static final List<String> RESULT_TYPES = Arrays.asList("string", "boolean", "number", "node", "node_list", "document_list");
    private static final XmlPayloadConverter CONVERTER = new DefaultXmlPayloadConverter();
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactoryUtils.newInstance();

    public static <T> @Nullable T evaluate(Object object, String xpath, Object ... resultArg) {
        Object resultType = null;
        if (resultArg != null && resultArg.length > 0) {
            Assert.isTrue((resultArg.length == 1 ? 1 : 0) != 0, (String)"'resultArg' can contains only one element.");
            Assert.noNullElements((Object[])resultArg, (String)"'resultArg' can't contains 'null' elements.");
            resultType = resultArg[0];
        }
        XPathExpression expression = XPathExpressionFactory.createXPathExpression((String)xpath);
        Node node = CONVERTER.convertToNode(object);
        if (resultType == null) {
            return (T)expression.evaluateAsString(node);
        }
        if (resultType instanceof NodeMapper) {
            return (T)expression.evaluateAsObject(node, (NodeMapper)resultType);
        }
        if (resultType instanceof String) {
            String resType = (String)resultType;
            if (RESULT_TYPES.contains(resultType)) {
                if (DOCUMENT_LIST.equals(resType)) {
                    List nodeList = (List)XPathEvaluationType.NODE_LIST_RESULT.evaluateXPath(expression, node);
                    Assert.notNull((Object)nodeList, (String)"'nodeList' must not be null.");
                    try {
                        DocumentBuilder documentBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
                        ArrayList<Document> documents = new ArrayList<Document>(nodeList.size());
                        for (Node n : nodeList) {
                            Document document = documentBuilder.newDocument();
                            document.appendChild(document.importNode(n, true));
                            documents.add(document);
                        }
                        return (T)documents;
                    }
                    catch (ParserConfigurationException e) {
                        throw new XPathException("Unable to create 'documentBuilder'.", (Throwable)e);
                    }
                }
                XPathEvaluationType evaluationType = XPathEvaluationType.valueOf(resType.toUpperCase() + "_RESULT");
                return (T)evaluationType.evaluateXPath(expression, node);
            }
        }
        throw new IllegalArgumentException("'resultArg[0]' can be an instance of 'NodeMapper<?>' or one of supported String constants: " + String.valueOf(RESULT_TYPES));
    }

    private XPathUtils() {
    }

    static {
        DOCUMENT_BUILDER_FACTORY.setNamespaceAware(true);
    }
}

