/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.FilterFactoryBean;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.xml.config.XPathExpressionParser;
import org.springframework.integration.xml.selector.BooleanTestXPathMessageSelector;
import org.springframework.integration.xml.selector.RegexTestXPathMessageSelector;
import org.springframework.integration.xml.selector.StringValueTestXPathMessageSelector;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XPathFilterParser
extends AbstractConsumerEndpointParser {
    private final XPathExpressionParser xpathParser = new XPathExpressionParser();

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder selectorBuilder = BeanDefinitionBuilder.genericBeanDefinition();
        selectorBuilder.getBeanDefinition().setBeanClass(BooleanTestXPathMessageSelector.class);
        this.configureXPathExpression(element, selectorBuilder, parserContext);
        if (element.hasAttribute("match-value")) {
            selectorBuilder.addConstructorArgValue((Object)element.getAttribute("match-value"));
            String matchType = element.getAttribute("match-type");
            if ("exact".equals(matchType)) {
                selectorBuilder.getBeanDefinition().setBeanClass(StringValueTestXPathMessageSelector.class);
            } else if ("case-insensitive".equals(matchType)) {
                selectorBuilder.getBeanDefinition().setBeanClass(StringValueTestXPathMessageSelector.class);
                selectorBuilder.addPropertyValue("caseSensitive", (Object)false);
            } else if ("regex".equals(matchType)) {
                selectorBuilder.getBeanDefinition().setBeanClass(RegexTestXPathMessageSelector.class);
            }
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(FilterFactoryBean.class);
        builder.addPropertyValue("targetObject", (Object)selectorBuilder.getBeanDefinition());
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"discard-channel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"throw-exception-on-rejection");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"send-timeout");
        return builder;
    }

    private void configureXPathExpression(Element element, BeanDefinitionBuilder selectorBuilder, ParserContext parserContext) {
        String xPathExpressionRef = element.getAttribute("xpath-expression-ref");
        NodeList xPathExpressionNodes = element.getElementsByTagNameNS(element.getNamespaceURI(), "xpath-expression");
        Assert.isTrue((xPathExpressionNodes.getLength() <= 1 ? 1 : 0) != 0, (String)"At most one xpath-expression child may be specified.");
        boolean xPathExpressionChildPresent = xPathExpressionNodes.getLength() == 1;
        boolean xPathReferencePresent = StringUtils.hasText((String)xPathExpressionRef);
        Assert.isTrue((boolean)(xPathExpressionChildPresent ^ xPathReferencePresent), (String)"Exactly one of 'xpath-expression' or 'xpath-expression-ref' is required.");
        if (xPathExpressionChildPresent) {
            BeanDefinition beanDefinition = this.xpathParser.parse((Element)xPathExpressionNodes.item(0), parserContext);
            selectorBuilder.addConstructorArgValue((Object)beanDefinition);
        } else {
            selectorBuilder.addConstructorArgReference(xPathExpressionRef);
        }
    }
}

