/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.springframework.integration.mapping.AbstractHeaderMapper;
import org.springframework.integration.ws.SoapHeaderMapper;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapHeaderException;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.xml.namespace.QNameUtils;
import org.springframework.xml.transform.TransformerHelper;

public class DefaultSoapHeaderMapper
extends AbstractHeaderMapper<SoapMessage>
implements SoapHeaderMapper {
    protected static final List<String> STANDARD_HEADER_NAMES = new ArrayList<String>();
    protected final TransformerHelper transformerHelper = new TransformerHelper();

    public DefaultSoapHeaderMapper() {
        super("ws_", STANDARD_HEADER_NAMES, Collections.emptyList());
    }

    protected Map<String, Object> extractStandardHeaders(SoapMessage source) {
        String soapAction = source.getSoapAction();
        if (StringUtils.hasText((String)soapAction)) {
            HashMap<String, Object> headers = new HashMap<String, Object>(1);
            headers.put("ws_soapAction", soapAction);
            return headers;
        }
        return Collections.emptyMap();
    }

    protected Map<String, Object> extractUserDefinedHeaders(SoapMessage source) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        SoapHeader soapHeader = source.getSoapHeader();
        if (soapHeader != null) {
            Iterator attributeIter = soapHeader.getAllAttributes();
            while (attributeIter.hasNext()) {
                Object name = attributeIter.next();
                if (!(name instanceof QName)) continue;
                String qnameString = QNameUtils.toQualifiedName((QName)((QName)name));
                String value = soapHeader.getAttributeValue((QName)name);
                if (value == null) continue;
                headers.put(qnameString, value);
            }
            Iterator elementIter = soapHeader.examineAllHeaderElements();
            while (elementIter.hasNext()) {
                Object element = elementIter.next();
                if (!(element instanceof SoapHeaderElement)) continue;
                QName qname = ((SoapHeaderElement)element).getName();
                String qnameString = QNameUtils.toQualifiedName((QName)qname);
                headers.put(qnameString, element);
            }
        }
        return headers;
    }

    protected void populateStandardHeaders(Map<String, Object> headers, SoapMessage target) {
        String soapAction = (String)this.getHeaderIfAvailable(headers, "ws_soapAction", String.class);
        if (StringUtils.hasText((String)soapAction)) {
            target.setSoapAction(soapAction);
        } else if (!StringUtils.hasText((String)target.getSoapAction())) {
            target.setSoapAction("\"\"");
        }
    }

    protected void populateUserDefinedHeader(String headerName, Object headerValue, SoapMessage target) {
        SoapHeader soapHeader = target.getSoapHeader();
        if (headerValue instanceof String) {
            QName qname = QNameUtils.parseQNameString((String)headerName);
            soapHeader.addAttribute(qname, (String)headerValue);
        } else if (headerValue instanceof Source) {
            Result result = soapHeader.getResult();
            try {
                this.transformerHelper.transform((Source)headerValue, result);
            }
            catch (TransformerException e) {
                throw new SoapHeaderException("Could not transform source [" + String.valueOf(headerValue) + "] to result [" + String.valueOf(result) + "]", (Throwable)e);
            }
        }
    }

    static {
        STANDARD_HEADER_NAMES.add("ws_soapAction");
    }
}

