/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ws.config;

import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.AbstractOutboundGatewayParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.ws.DefaultSoapHeaderMapper;
import org.springframework.integration.ws.MarshallingWebServiceOutboundGateway;
import org.springframework.integration.ws.SimpleWebServiceOutboundGateway;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class WebServiceOutboundGatewayParser
extends AbstractOutboundGatewayParser {
    protected String getGatewayClassName(Element element) {
        return (StringUtils.hasText((String)element.getAttribute("marshaller")) ? MarshallingWebServiceOutboundGateway.class : SimpleWebServiceOutboundGateway.class).getName();
    }

    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)this.getGatewayClassName(element));
        String uri = element.getAttribute("uri");
        String destinationProvider = element.getAttribute("destination-provider");
        List uriVariableElements = DomUtils.getChildElementsByTagName((Element)element, (String)"uri-variable");
        if (StringUtils.hasText((String)destinationProvider) == StringUtils.hasText((String)uri)) {
            parserContext.getReaderContext().error("Exactly one of 'uri' or 'destination-provider' is required.", (Object)element);
        }
        if (StringUtils.hasText((String)destinationProvider)) {
            if (!CollectionUtils.isEmpty((Collection)uriVariableElements)) {
                parserContext.getReaderContext().error("No 'uri-variable' sub-elements are allowed when a 'destination-provider' reference has been provided.", (Object)element);
            }
            builder.addConstructorArgReference(destinationProvider);
        } else {
            builder.addConstructorArgValue((Object)uri);
            if (!CollectionUtils.isEmpty((Collection)uriVariableElements)) {
                ManagedMap uriVariableExpressions = new ManagedMap();
                for (Element uriVariableElement : uriVariableElements) {
                    String name = uriVariableElement.getAttribute("name");
                    String expression = uriVariableElement.getAttribute("expression");
                    BeanDefinitionBuilder factoryBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class);
                    factoryBeanBuilder.addConstructorArgValue((Object)expression);
                    uriVariableExpressions.put((Object)name, (Object)factoryBeanBuilder.getBeanDefinition());
                }
                builder.addPropertyValue("uriVariableExpressions", (Object)uriVariableExpressions);
            }
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-channel");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout", (String)"sendTimeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"requires-reply");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"ignore-empty-responses");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"encode-uri");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"encoding-mode");
        this.postProcessGateway(builder, element, parserContext);
        IntegrationNamespaceUtils.configureHeaderMapper((Element)element, (BeanDefinitionBuilder)builder, (ParserContext)parserContext, DefaultSoapHeaderMapper.class, null);
        return builder;
    }

    protected void postProcessGateway(BeanDefinitionBuilder builder, Element element, ParserContext parserContext) {
        this.parseMarshallerAttribute(builder, element, parserContext);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"request-callback");
        String webServiceTemplateRef = element.getAttribute("web-service-template");
        if (StringUtils.hasText((String)webServiceTemplateRef)) {
            builder.addPropertyReference("webServiceTemplate", webServiceTemplateRef);
            return;
        }
        String messageFactoryRef = element.getAttribute("message-factory");
        if (StringUtils.hasText((String)messageFactoryRef)) {
            builder.addConstructorArgReference(messageFactoryRef);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"fault-message-resolver");
        String messageSenderRef = element.getAttribute("message-sender");
        String messageSenderListRef = element.getAttribute("message-senders");
        if (StringUtils.hasText((String)messageSenderRef) && StringUtils.hasText((String)messageSenderListRef)) {
            parserContext.getReaderContext().error("Only one of message-sender or message-senders should be specified.", (Object)element);
        }
        if (StringUtils.hasText((String)messageSenderRef)) {
            builder.addPropertyReference("messageSender", messageSenderRef);
        }
        if (StringUtils.hasText((String)messageSenderListRef)) {
            builder.addPropertyReference("messageSenders", messageSenderListRef);
        }
        String interceptorRef = element.getAttribute("interceptor");
        String interceptorListRef = element.getAttribute("interceptors");
        if (StringUtils.hasText((String)interceptorRef) && StringUtils.hasText((String)interceptorListRef)) {
            parserContext.getReaderContext().error("Only one of interceptor or interceptors should be specified.", (Object)element);
        }
        if (StringUtils.hasText((String)interceptorRef)) {
            builder.addPropertyReference("interceptors", interceptorRef);
        }
        if (StringUtils.hasText((String)interceptorListRef)) {
            builder.addPropertyReference("interceptors", interceptorListRef);
        }
    }

    private void parseMarshallerAttribute(BeanDefinitionBuilder builder, Element element, ParserContext parserContext) {
        String marshallerRef = element.getAttribute("marshaller");
        String unmarshallerRef = element.getAttribute("unmarshaller");
        if (StringUtils.hasText((String)marshallerRef)) {
            builder.addConstructorArgReference(marshallerRef);
            if (StringUtils.hasText((String)unmarshallerRef)) {
                builder.addConstructorArgReference(unmarshallerRef);
            }
        } else {
            String sourceExtractorRef = element.getAttribute("source-extractor");
            if (StringUtils.hasText((String)sourceExtractorRef)) {
                builder.addConstructorArgReference(sourceExtractorRef);
            } else {
                builder.addConstructorArgValue(null);
            }
        }
        if (StringUtils.hasText((String)marshallerRef) || StringUtils.hasText((String)unmarshallerRef)) {
            String extractPayload = element.getAttribute("extract-payload");
            if (StringUtils.hasText((String)extractPayload)) {
                parserContext.getReaderContext().warning("Setting 'extract-payload' attribute has no effect when used with a marshalling Web Service Outbound Gateway.", (Object)element);
            }
        } else {
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"extract-payload");
        }
    }
}

