/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.endpoint.IntegrationConsumer;
import org.springframework.integration.endpoint.ReactiveStreamsConsumer;
import org.springframework.integration.endpoint.SourcePollingChannelAdapter;
import org.springframework.integration.test.mock.MockMessageHandler;
import org.springframework.integration.test.util.TestUtils;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class MockIntegrationContext
implements BeanPostProcessor,
SmartInitializingSingleton,
BeanFactoryAware {
    private static final String HANDLER = "handler";
    public static final String MOCK_INTEGRATION_CONTEXT_BEAN_NAME = "mockIntegrationContext";
    private final Map<String, Object> beans = new HashMap<String, Object>();
    private final List<AbstractEndpoint> autoStartupCandidates = new ArrayList<AbstractEndpoint>();
    private ConfigurableListableBeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isAssignable(ConfigurableListableBeanFactory.class, beanFactory.getClass(), (String)"a ConfigurableListableBeanFactory is required");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        AbstractEndpoint endpoint;
        if (bean instanceof AbstractEndpoint && (endpoint = (AbstractEndpoint)bean).isAutoStartup()) {
            this.addAutoStartupCandidates(endpoint);
        }
        return bean;
    }

    private void addAutoStartupCandidates(AbstractEndpoint endpoint) {
        endpoint.setAutoStartup(false);
        this.autoStartupCandidates.add(endpoint);
    }

    public void afterSingletonsInstantiated() {
        this.beanFactory.getBeansOfType(AbstractEndpoint.class).values().stream().filter(AbstractEndpoint::isAutoStartup).forEach(this::addAutoStartupCandidates);
    }

    List<AbstractEndpoint> getAutoStartupCandidates() {
        return this.autoStartupCandidates;
    }

    public void resetBeans(String ... beanNames) {
        List<String> names = !ObjectUtils.isEmpty((Object[])beanNames) ? Arrays.asList(beanNames) : null;
        this.beans.entrySet().stream().filter(e -> names == null || names.contains(e.getKey())).forEach(e -> this.resetBean(this.beanFactory.getBean((String)e.getKey()), e.getValue()));
        if (!ObjectUtils.isEmpty((Object[])beanNames)) {
            for (String name : beanNames) {
                this.beans.remove(name);
            }
        } else {
            this.beans.clear();
        }
    }

    private void resetBean(Object endpoint, Object handler) {
        DirectFieldAccessor directFieldAccessor = new DirectFieldAccessor(endpoint);
        SmartLifecycle lifecycle = null;
        if (endpoint instanceof SmartLifecycle && ((SmartLifecycle)endpoint).isRunning()) {
            lifecycle = (SmartLifecycle)endpoint;
            lifecycle.stop();
        }
        if (endpoint instanceof SourcePollingChannelAdapter) {
            directFieldAccessor.setPropertyValue("source", handler);
        } else if (endpoint instanceof ReactiveStreamsConsumer) {
            Tuple2 value = (Tuple2)handler;
            directFieldAccessor.setPropertyValue(HANDLER, value.getT1());
            directFieldAccessor.setPropertyValue("subscriber", value.getT2());
        } else if (endpoint instanceof IntegrationConsumer) {
            directFieldAccessor.setPropertyValue(HANDLER, handler);
        }
        if (lifecycle != null && lifecycle.isAutoStartup()) {
            lifecycle.start();
        }
    }

    public void substituteMessageSourceFor(String pollingAdapterId, MessageSource<?> mockMessageSource) {
        this.substituteMessageSourceFor(pollingAdapterId, mockMessageSource, true);
    }

    public void substituteMessageSourceFor(String pollingAdapterId, MessageSource<?> mockMessageSource, boolean autoStartup) {
        this.substituteMessageSourceFor(pollingAdapterId, mockMessageSource, SourcePollingChannelAdapter.class, "source", autoStartup);
    }

    public void substituteMessageHandlerFor(String consumerEndpointId, MessageHandler mockMessageHandler) {
        this.substituteMessageHandlerFor(consumerEndpointId, mockMessageHandler, true);
    }

    public void substituteMessageHandlerFor(String consumerEndpointId, MessageHandler mockMessageHandler, boolean autoStartup) {
        Object endpoint = this.beanFactory.getBean(consumerEndpointId, IntegrationConsumer.class);
        if (autoStartup && endpoint instanceof Lifecycle) {
            ((Lifecycle)endpoint).stop();
        }
        DirectFieldAccessor directFieldAccessor = new DirectFieldAccessor(endpoint);
        Object targetMessageHandler = directFieldAccessor.getPropertyValue(HANDLER);
        Assert.notNull((Object)targetMessageHandler, () -> "'handler' must not be null in the: " + endpoint);
        if (endpoint instanceof ReactiveStreamsConsumer) {
            Object targetSubscriber = directFieldAccessor.getPropertyValue("subscriber");
            Assert.notNull((Object)targetSubscriber, () -> "'subscriber' must not be null in the: " + endpoint);
            this.beans.put(consumerEndpointId, Tuples.of((Object)targetMessageHandler, (Object)targetSubscriber));
        } else {
            this.beans.put(consumerEndpointId, targetMessageHandler);
        }
        if (mockMessageHandler instanceof MessageProducer) {
            if (targetMessageHandler instanceof MessageProducer) {
                MessageChannel outputChannel = ((MessageProducer)targetMessageHandler).getOutputChannel();
                ((MessageProducer)mockMessageHandler).setOutputChannel(outputChannel);
            } else if (mockMessageHandler instanceof MockMessageHandler) {
                if (((Boolean)TestUtils.getPropertyValue((Object)mockMessageHandler, (String)"hasReplies", Boolean.class)).booleanValue()) {
                    throw new IllegalStateException("The [" + mockMessageHandler + "] with replies can't replace simple MessageHandler [" + targetMessageHandler + "]");
                }
            } else {
                throw new IllegalStateException("The MessageProducer handler [" + mockMessageHandler + "] can't replace simple MessageHandler [" + targetMessageHandler + "]");
            }
        }
        directFieldAccessor.setPropertyValue(HANDLER, (Object)mockMessageHandler);
        if (endpoint instanceof ReactiveStreamsConsumer) {
            directFieldAccessor.setPropertyValue("subscriber", (Object)mockMessageHandler);
        }
        if (autoStartup && endpoint instanceof Lifecycle) {
            ((Lifecycle)endpoint).start();
        }
    }

    private void substituteMessageSourceFor(String endpointId, Object messagingComponent, Class<?> endpointClass, String property, boolean autoStartup) {
        Object endpoint = this.beanFactory.getBean(endpointId, endpointClass);
        if (autoStartup && endpoint instanceof Lifecycle) {
            ((Lifecycle)endpoint).stop();
        }
        DirectFieldAccessor directFieldAccessor = new DirectFieldAccessor(endpoint);
        this.beans.put(endpointId, directFieldAccessor.getPropertyValue(property));
        directFieldAccessor.setPropertyValue(property, messagingComponent);
        if (autoStartup && endpoint instanceof Lifecycle) {
            ((Lifecycle)endpoint).start();
        }
    }
}

