/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.rule;

import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.jspecify.annotations.Nullable;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.springframework.integration.test.util.TestUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Deprecated(since="7.0", forRemoval=true)
public final class Log4j2LevelAdjuster
implements MethodRule {
    private final Class<?>[] classes;
    private final Level level;
    private final String[] categories;

    private Log4j2LevelAdjuster(Level level) {
        this(level, null, new String[]{"org.springframework.integration"});
    }

    private Log4j2LevelAdjuster(Level level, Class<?> @Nullable [] classes, String[] categories) {
        Assert.notNull((Object)level, (String)"'level' must be null");
        this.level = level;
        this.classes = classes != null ? classes : new Class[]{};
        Stream<String> categoryStream = Stream.of(this.getClass().getPackage().getName());
        if (!ObjectUtils.isEmpty((Object[])categories)) {
            categoryStream = Stream.concat(Arrays.stream(categories), categoryStream);
        }
        this.categories = (String[])categoryStream.toArray(String[]::new);
    }

    public Statement apply(final Statement base, final FrameworkMethod method, Object target) {
        class AdjustingStatement
        extends Statement {
            final /* synthetic */ Log4j2LevelAdjuster this$0;

            AdjustingStatement() {
                this.this$0 = this$0;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void evaluate() throws Throwable {
                TestUtils.LevelsContainer container = null;
                try {
                    container = TestUtils.adjustLogLevels(method.getName(), Arrays.asList(this.this$0.classes), Arrays.asList(this.this$0.categories), this.this$0.level);
                    base.evaluate();
                    if (container == null) return;
                }
                catch (Throwable throwable) {
                    if (container == null) throw throwable;
                    TestUtils.revertLogLevels(method.getName(), container);
                    throw throwable;
                }
                TestUtils.revertLogLevels(method.getName(), container);
            }
        }
        return new AdjustingStatement();
    }

    public Log4j2LevelAdjuster classes(Class<?> ... clazzes) {
        return this.classes(false, clazzes);
    }

    public Log4j2LevelAdjuster classes(boolean merge, Class<?> ... classesToAdjust) {
        return new Log4j2LevelAdjuster(this.level, merge ? (Class[])Stream.of(this.classes, classesToAdjust).flatMap(Stream::of).toArray(Class[]::new) : classesToAdjust, this.categories);
    }

    public Log4j2LevelAdjuster categories(String ... categoriesToAdjust) {
        return this.categories(false, categoriesToAdjust);
    }

    public Log4j2LevelAdjuster categories(boolean merge, String ... categories) {
        return new Log4j2LevelAdjuster(this.level, this.classes, merge ? (String[])Stream.of(this.categories, categories).flatMap(Stream::of).toArray(String[]::new) : categories);
    }

    public static Log4j2LevelAdjuster trace() {
        return Log4j2LevelAdjuster.forLevel(Level.TRACE);
    }

    public static Log4j2LevelAdjuster debug() {
        return Log4j2LevelAdjuster.forLevel(Level.DEBUG);
    }

    public static Log4j2LevelAdjuster info() {
        return Log4j2LevelAdjuster.forLevel(Level.INFO);
    }

    public static Log4j2LevelAdjuster forLevel(Level level) {
        return new Log4j2LevelAdjuster(level);
    }
}

