/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.test.support;

import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.springframework.integration.test.util.TestUtils;

public interface TestApplicationContextAware {
    public static final TestUtils.TestApplicationContext TEST_INTEGRATION_CONTEXT = TestUtils.createTestApplicationContext();

    @BeforeAll
    public static void beforeAll() {
        block2: {
            try {
                TEST_INTEGRATION_CONTEXT.refresh();
            }
            catch (IllegalStateException ex) {
                if (Objects.requireNonNull(ex.getMessage()).contains("just call 'refresh' once")) break block2;
                throw ex;
            }
        }
        Object nullChannel = TEST_INTEGRATION_CONTEXT.getBean("nullChannel");
        TestUtils.getPropertyValue(nullChannel, "queue", LinkedBlockingQueue.class).clear();
    }

    @AfterAll
    public static void tearDown() {
        TEST_INTEGRATION_CONTEXT.close();
    }
}

