/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.session;

import java.nio.file.attribute.PosixFilePermissions;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.common.SftpHelper;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.util.Assert;

public class SftpFileInfo
extends AbstractFileInfo<SftpClient.DirEntry> {
    private final SftpClient.DirEntry lsEntry;
    private final SftpClient.Attributes attrs;

    public SftpFileInfo(SftpClient.DirEntry lsEntry) {
        Assert.notNull((Object)lsEntry, (String)"'lsEntry' must not be null");
        this.lsEntry = lsEntry;
        this.attrs = lsEntry.getAttributes();
    }

    public boolean isDirectory() {
        return this.attrs.isDirectory();
    }

    public boolean isLink() {
        return this.attrs.isSymbolicLink();
    }

    public long getSize() {
        return this.attrs.getSize();
    }

    public long getModified() {
        return this.attrs.getModifyTime().toMillis();
    }

    public String getFilename() {
        return this.lsEntry.getFilename();
    }

    public String getPermissions() {
        return PosixFilePermissions.toString(SftpHelper.permissionsToAttributes((int)this.attrs.getPermissions()));
    }

    public SftpClient.DirEntry getFileInfo() {
        return this.lsEntry;
    }
}

