/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.outbound;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.sshd.sftp.client.SftpClient;
import org.springframework.integration.file.remote.ClientCallback;
import org.springframework.integration.file.remote.ClientCallbackWithoutResult;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.handler.FileTransferringMessageHandler;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.support.FileExistsMode;
import org.springframework.integration.sftp.session.SftpRemoteFileTemplate;

public class SftpMessageHandler
extends FileTransferringMessageHandler<SftpClient.DirEntry> {
    public SftpMessageHandler(SftpRemoteFileTemplate remoteFileTemplate) {
        super((RemoteFileTemplate)remoteFileTemplate);
    }

    public SftpMessageHandler(SftpRemoteFileTemplate remoteFileTemplate, FileExistsMode mode) {
        super((RemoteFileTemplate)remoteFileTemplate, mode);
    }

    public SftpMessageHandler(SessionFactory<SftpClient.DirEntry> sessionFactory) {
        this(new SftpRemoteFileTemplate(sessionFactory));
    }

    public boolean isChmodCapable() {
        return true;
    }

    protected void doChmod(RemoteFileTemplate<SftpClient.DirEntry> remoteFileTemplate, String path, int chmod) {
        remoteFileTemplate.executeWithClient((ClientCallback)((ClientCallbackWithoutResult)client -> {
            try {
                SftpClient.Attributes attributes = client.stat(path);
                attributes.setPermissions(chmod);
                client.setStat(path, attributes);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to execute 'chmod " + Integer.toOctalString(chmod) + " " + path + "'", ex);
            }
        }));
    }
}

