/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.dsl;

import java.util.Comparator;
import org.apache.sshd.sftp.client.SftpClient;
import org.springframework.integration.file.dsl.RemoteFileStreamingInboundChannelAdapterSpec;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.integration.sftp.filters.SftpPersistentAcceptOnceFileListFilter;
import org.springframework.integration.sftp.filters.SftpRegexPatternFileListFilter;
import org.springframework.integration.sftp.filters.SftpSimplePatternFileListFilter;
import org.springframework.integration.sftp.inbound.SftpStreamingMessageSource;
import org.springframework.lang.Nullable;

public class SftpStreamingInboundChannelAdapterSpec
extends RemoteFileStreamingInboundChannelAdapterSpec<SftpClient.DirEntry, SftpStreamingInboundChannelAdapterSpec, SftpStreamingMessageSource> {
    protected SftpStreamingInboundChannelAdapterSpec(RemoteFileTemplate<SftpClient.DirEntry> remoteFileTemplate, @Nullable Comparator<SftpClient.DirEntry> comparator) {
        this.target = new SftpStreamingMessageSource(remoteFileTemplate, comparator);
    }

    public SftpStreamingInboundChannelAdapterSpec patternFilter(String pattern) {
        return (SftpStreamingInboundChannelAdapterSpec)this.filter((FileListFilter)this.composeFilters((FileListFilter<SftpClient.DirEntry>)new SftpSimplePatternFileListFilter(pattern)));
    }

    public SftpStreamingInboundChannelAdapterSpec regexFilter(String regex) {
        return (SftpStreamingInboundChannelAdapterSpec)this.filter((FileListFilter)this.composeFilters((FileListFilter<SftpClient.DirEntry>)new SftpRegexPatternFileListFilter(regex)));
    }

    private CompositeFileListFilter<SftpClient.DirEntry> composeFilters(FileListFilter<SftpClient.DirEntry> fileListFilter) {
        CompositeFileListFilter compositeFileListFilter = new CompositeFileListFilter();
        compositeFileListFilter.addFilters(new FileListFilter[]{fileListFilter, new SftpPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "sftpStreamingMessageSource")});
        return compositeFileListFilter;
    }
}

