/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.sftp.dsl;

import com.jcraft.jsch.ChannelSftp;
import java.util.Comparator;
import org.springframework.integration.file.dsl.RemoteFileStreamingInboundChannelAdapterSpec;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.metadata.ConcurrentMetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.integration.sftp.filters.SftpPersistentAcceptOnceFileListFilter;
import org.springframework.integration.sftp.filters.SftpRegexPatternFileListFilter;
import org.springframework.integration.sftp.filters.SftpSimplePatternFileListFilter;
import org.springframework.integration.sftp.inbound.SftpStreamingMessageSource;

public class SftpStreamingInboundChannelAdapterSpec
extends RemoteFileStreamingInboundChannelAdapterSpec<ChannelSftp.LsEntry, SftpStreamingInboundChannelAdapterSpec, SftpStreamingMessageSource> {
    protected SftpStreamingInboundChannelAdapterSpec(RemoteFileTemplate<ChannelSftp.LsEntry> remoteFileTemplate, Comparator<ChannelSftp.LsEntry> comparator) {
        this.target = new SftpStreamingMessageSource(remoteFileTemplate, comparator);
    }

    public SftpStreamingInboundChannelAdapterSpec patternFilter(String pattern) {
        return (SftpStreamingInboundChannelAdapterSpec)this.filter((FileListFilter)this.composeFilters((FileListFilter<ChannelSftp.LsEntry>)new SftpSimplePatternFileListFilter(pattern)));
    }

    public SftpStreamingInboundChannelAdapterSpec regexFilter(String regex) {
        return (SftpStreamingInboundChannelAdapterSpec)this.filter((FileListFilter)this.composeFilters((FileListFilter<ChannelSftp.LsEntry>)new SftpRegexPatternFileListFilter(regex)));
    }

    private CompositeFileListFilter<ChannelSftp.LsEntry> composeFilters(FileListFilter<ChannelSftp.LsEntry> fileListFilter) {
        CompositeFileListFilter compositeFileListFilter = new CompositeFileListFilter();
        compositeFileListFilter.addFilters(new FileListFilter[]{fileListFilter, new SftpPersistentAcceptOnceFileListFilter((ConcurrentMetadataStore)new SimpleMetadataStore(), "sftpStreamingMessageSource")});
        return compositeFileListFilter;
    }
}

