/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.integration.ip.tcp.serializer.AbstractPooledBufferByteArraySerializer;
import org.springframework.integration.ip.tcp.serializer.SoftEndOfStreamException;

public class ByteArrayCrLfSerializer
extends AbstractPooledBufferByteArraySerializer {
    public static final ByteArrayCrLfSerializer INSTANCE = new ByteArrayCrLfSerializer();
    private static final byte[] CRLF = "\r\n".getBytes();

    @Override
    public byte[] doDeserialize(InputStream inputStream, byte[] buffer) throws IOException {
        int n = this.fillToCrLf(inputStream, buffer);
        return this.copyToSizedArray(buffer, n);
    }

    public int fillToCrLf(InputStream inputStream, byte[] buffer) throws IOException {
        int n = 0;
        int available = inputStream.available();
        this.logger.debug(() -> "Available to read: " + available);
        try {
            block5: {
                do {
                    int bite;
                    if ((bite = inputStream.read()) < 0 && n == 0) {
                        throw new SoftEndOfStreamException("Stream closed between payloads");
                    }
                    this.checkClosure(bite);
                    if (n > 0 && bite == 10 && buffer[n - 1] == 13) break block5;
                    buffer[n++] = (byte)bite;
                } while (n < this.getMaxMessageSize());
                throw new IOException("CRLF not found before max message length: " + this.getMaxMessageSize());
            }
            return n - 1;
        }
        catch (SoftEndOfStreamException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            this.publishEvent(e, buffer, n);
            throw e;
        }
    }

    public void serialize(byte[] bytes, OutputStream outputStream) throws IOException {
        outputStream.write(bytes);
        outputStream.write(CRLF);
    }
}

