/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.support;

import java.util.Objects;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.support.WebExchangeBindException;

public class IntegrationWebExchangeBindException
extends WebExchangeBindException {
    private final String endpointId;
    private final Object failedPayload;

    public IntegrationWebExchangeBindException(String endpointId, Object failedPayload, BindingResult bindingResult) {
        super(null, bindingResult);
        this.endpointId = endpointId;
        this.failedPayload = failedPayload;
    }

    public String getMessage() {
        BindingResult bindingResult = this.getBindingResult();
        StringBuilder sb = new StringBuilder("Validation failed for payload ").append(this.failedPayload).append(" in the endpoint ").append(this.endpointId).append(", with ").append(bindingResult.getErrorCount()).append(" error(s): ");
        for (ObjectError error : bindingResult.getAllErrors()) {
            sb.append("[").append(error).append("] ");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntegrationWebExchangeBindException)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntegrationWebExchangeBindException that = (IntegrationWebExchangeBindException)((Object)o);
        return Objects.equals(this.endpointId, that.endpointId) && Objects.equals(this.failedPayload, that.failedPayload);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.endpointId, this.failedPayload);
    }
}

