/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.integration.http.inbound.HttpRequestHandlingEndpointSupport;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.CollectionUtils;
import org.springframework.web.HttpRequestHandler;

public class HttpRequestHandlingMessagingGateway
extends HttpRequestHandlingEndpointSupport
implements HttpRequestHandler {
    private volatile boolean convertExceptions;

    public HttpRequestHandlingMessagingGateway() {
        this(true);
    }

    public HttpRequestHandlingMessagingGateway(boolean expectReply) {
        super(expectReply);
    }

    public void setConvertExceptions(boolean convertExceptions) {
        this.convertExceptions = convertExceptions;
    }

    public final void handleRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        Object responseContent = null;
        ServletServerHttpRequest request = this.prepareRequest(servletRequest);
        ServletServerHttpResponse response = new ServletServerHttpResponse(servletResponse);
        RequestEntity<Object> httpEntity = this.prepareRequestEntity(request);
        try {
            Message<?> responseMessage = this.doHandleRequest(servletRequest, httpEntity);
            if (responseMessage != null) {
                responseContent = this.setupResponseAndConvertReply(response, responseMessage);
            }
        }
        catch (Exception ex) {
            responseContent = this.handleExceptionInternal(ex);
        }
        if (responseContent != null) {
            if (responseContent instanceof HttpStatus) {
                response.setStatusCode((HttpStatus)responseContent);
            } else {
                if (responseContent instanceof ResponseEntity) {
                    ResponseEntity responseEntity = (ResponseEntity)responseContent;
                    responseContent = responseEntity.getBody();
                    response.setStatusCode(responseEntity.getStatusCode());
                    HttpHeaders outputHeaders = response.getHeaders();
                    HttpHeaders entityHeaders = responseEntity.getHeaders();
                    entityHeaders.entrySet().stream().filter(entry -> !outputHeaders.containsKey(entry.getKey())).forEach(entry -> outputHeaders.put((String)entry.getKey(), (List)entry.getValue()));
                }
                if (responseContent != null) {
                    this.writeResponse(responseContent, response, request.getHeaders().getAccept());
                } else {
                    response.flush();
                }
            }
        } else {
            this.setStatusCodeIfNeeded((ServerHttpResponse)response, (HttpEntity<?>)httpEntity);
        }
    }

    private Object handleExceptionInternal(Exception ex) throws IOException {
        if (this.convertExceptions && this.isExpectReply()) {
            return ex;
        }
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new MessagingException("error occurred handling HTTP request", (Throwable)ex);
    }

    private void writeResponse(Object content, ServletServerHttpResponse response, List<MediaType> acceptTypesArg) throws IOException {
        List<MediaType> acceptTypes = acceptTypesArg;
        if (CollectionUtils.isEmpty(acceptTypes)) {
            acceptTypes = Collections.singletonList(MediaType.ALL);
        }
        for (HttpMessageConverter<?> converter : this.getMessageConverters()) {
            for (MediaType acceptType : acceptTypes) {
                if (!converter.canWrite(content.getClass(), acceptType)) continue;
                HttpMessageConverter<?> converterToUse = converter;
                converterToUse.write(content, acceptType, (HttpOutputMessage)response);
                return;
            }
        }
        throw new MessagingException("Could not convert reply: no suitable HttpMessageConverter found for type [" + content.getClass().getName() + "] and accept types [" + acceptTypes + "]");
    }
}

