/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.outbound;

import com.rabbitmq.stream.Message;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.integration.amqp.support.AmqpHeaderMapper;
import org.springframework.integration.amqp.support.DefaultAmqpHeaderMapper;
import org.springframework.integration.amqp.support.MappingUtils;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.rabbit.stream.producer.RabbitStreamOperations;
import org.springframework.rabbit.stream.support.StreamMessageProperties;
import org.springframework.util.Assert;

public class RabbitStreamMessageHandler
extends AbstractMessageHandler {
    private static final int DEFAULT_CONFIRM_TIMEOUT = 10000;
    private final RabbitStreamOperations streamOperations;
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();
    private boolean sync;
    private long confirmTimeout = 10000L;
    private @Nullable MessageChannel sendFailureChannel;
    private @Nullable String sendFailureChannelName;
    private @Nullable MessageChannel sendSuccessChannel;
    private @Nullable String sendSuccessChannelName;
    private AmqpHeaderMapper headerMapper = DefaultAmqpHeaderMapper.outboundMapper();
    private boolean headersMappedLast;

    public RabbitStreamMessageHandler(RabbitStreamOperations streamOperations) {
        Assert.notNull((Object)streamOperations, (String)"'streamOperations' cannot be null");
        this.streamOperations = streamOperations;
    }

    public void setSendFailureChannel(MessageChannel sendFailureChannel) {
        this.sendFailureChannel = sendFailureChannel;
    }

    public void setSendFailureChannelName(String sendFailureChannelName) {
        this.sendFailureChannelName = sendFailureChannelName;
    }

    public void setSendSuccessChannel(MessageChannel sendSuccessChannel) {
        this.sendSuccessChannel = sendSuccessChannel;
    }

    public void setSendSuccessChannelName(String sendSuccessChannelName) {
        this.sendSuccessChannelName = sendSuccessChannelName;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public void setConfirmTimeout(long confirmTimeout) {
        this.confirmTimeout = confirmTimeout;
    }

    public void setHeaderMapper(AmqpHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setHeadersMappedLast(boolean headersMappedLast) {
        this.headersMappedLast = headersMappedLast;
    }

    public RabbitStreamOperations getStreamOperations() {
        return this.streamOperations;
    }

    protected @Nullable MessageChannel getSendFailureChannel() {
        if (!(this.sendFailureChannel != null || this.sendFailureChannelName == null && this.sync)) {
            String sendFailureChannelNameToUse = this.sendFailureChannelName;
            if (sendFailureChannelNameToUse == null) {
                sendFailureChannelNameToUse = "errorChannel";
            }
            this.sendFailureChannel = (MessageChannel)this.getChannelResolver().resolveDestination(sendFailureChannelNameToUse);
        }
        return this.sendFailureChannel;
    }

    protected @Nullable MessageChannel getSendSuccessChannel() {
        if (this.sendSuccessChannel != null) {
            return this.sendSuccessChannel;
        }
        if (this.sendSuccessChannelName != null) {
            this.sendSuccessChannel = (MessageChannel)this.getChannelResolver().resolveDestination(this.sendSuccessChannelName);
            return this.sendSuccessChannel;
        }
        return null;
    }

    protected void handleMessageInternal(org.springframework.messaging.Message<?> requestMessage) {
        Message streamMessage;
        if (requestMessage.getPayload() instanceof Message) {
            streamMessage = (Message)requestMessage.getPayload();
        } else {
            MessageConverter converter = this.streamOperations.messageConverter();
            org.springframework.amqp.core.Message amqpMessage = RabbitStreamMessageHandler.mapMessage(requestMessage, converter, this.headerMapper, this.headersMappedLast);
            streamMessage = this.streamOperations.streamMessageConverter().fromMessage(amqpMessage);
        }
        CompletableFuture future = this.streamOperations.send(streamMessage);
        this.handleConfirms(requestMessage, future);
    }

    private void handleConfirms(org.springframework.messaging.Message<?> message, CompletableFuture<Boolean> future) {
        future.whenComplete((bool, ex) -> {
            if (ex != null) {
                MessageChannel failures = this.getSendFailureChannel();
                if (failures != null) {
                    this.messagingTemplate.send((Object)failures, (org.springframework.messaging.Message)new ErrorMessage(ex, message));
                }
            } else {
                MessageChannel successes = this.getSendSuccessChannel();
                if (successes != null) {
                    this.messagingTemplate.send((Object)successes, message);
                }
            }
        });
        if (this.sync) {
            try {
                future.get(this.confirmTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex2) {
                Thread.currentThread().interrupt();
                throw new MessageHandlingException(message, (Throwable)ex2);
            }
            catch (ExecutionException | TimeoutException ex3) {
                throw new MessageHandlingException(message, (Throwable)ex3);
            }
        }
    }

    private static org.springframework.amqp.core.Message mapMessage(org.springframework.messaging.Message<?> message, MessageConverter converter, AmqpHeaderMapper headerMapper, boolean headersMappedLast) {
        StreamMessageProperties amqpMessageProperties = new StreamMessageProperties();
        return MappingUtils.mapMessage(message, converter, headerMapper, headersMappedLast, headersMappedLast, (MessageProperties)amqpMessageProperties);
    }
}

