/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.dataloader.DataLoader;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.util.Assert;

public class DataLoaderMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().equals(DataLoader.class);
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) {
        DataLoader dataLoader = null;
        Class<?> valueType = this.getValueType(parameter);
        if (valueType != null) {
            dataLoader = environment.getDataLoader(valueType.getName());
        }
        String parameterName = null;
        if (dataLoader == null && (parameterName = parameter.getParameterName()) != null) {
            dataLoader = environment.getDataLoader(parameterName);
        }
        if (dataLoader == null) {
            String message = this.getErrorMessage(parameter, environment, valueType, parameterName);
            throw new IllegalArgumentException(message);
        }
        return dataLoader;
    }

    private @Nullable Class<?> getValueType(MethodParameter param) {
        ParameterizedType parameterizedType;
        Assert.isAssignable(DataLoader.class, (Class)param.getParameterType());
        Type genericType = param.getGenericParameterType();
        if (genericType instanceof ParameterizedType && (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments().length == 2) {
            Type valueType = parameterizedType.getActualTypeArguments()[1];
            return valueType instanceof Class ? (Class)valueType : ResolvableType.forType((Type)valueType).resolve();
        }
        return null;
    }

    private String getErrorMessage(MethodParameter parameter, DataFetchingEnvironment environment, @Nullable Class<?> valueType, @Nullable String parameterName) {
        StringBuilder builder = new StringBuilder("Cannot resolve DataLoader for parameter");
        if (parameterName != null) {
            builder.append(" '").append(parameterName).append("'");
        } else {
            builder.append("[").append(parameter.getParameterIndex()).append("]");
        }
        if (parameter.getMethod() != null) {
            builder.append(" in method ").append(parameter.getMethod().toGenericString());
        }
        builder.append(". ");
        if (valueType == null) {
            builder.append("If the batch loader was registered without a name, then declaring the DataLoader argument with generic types should help to look up the DataLoader based on the value type name.");
        } else if (parameterName == null) {
            builder.append("If the batch loader was registered with a name, then compiling with \"-parameters\" should help to look up the DataLoader based on the parameter name.");
        } else {
            builder.append("Neither the name of the declared value type '").append(valueType).append("' nor the method parameter name '").append(parameterName).append("' match to any DataLoader. The DataLoaderRegistry contains: ").append(environment.getDataLoaderRegistry().getKeys());
        }
        return builder.toString();
    }
}

