/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.client.ClientGraphQlRequest;
import org.springframework.graphql.client.ClientGraphQlResponse;
import org.springframework.graphql.client.ClientResponseField;
import org.springframework.graphql.client.DefaultClientGraphQlRequest;
import org.springframework.graphql.client.DefaultClientGraphQlResponse;
import org.springframework.graphql.client.FieldAccessException;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.graphql.client.GraphQlClientException;
import org.springframework.graphql.client.GraphQlClientInterceptor;
import org.springframework.graphql.client.GraphQlTransportException;
import org.springframework.graphql.client.SyncGraphQlClientInterceptor;
import org.springframework.graphql.support.DocumentSource;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

final class DefaultGraphQlClient
implements GraphQlClient {
    private final DocumentSource documentSource;
    private final SyncGraphQlClientInterceptor.Chain blockingChain;
    private final GraphQlClientInterceptor.Chain nonBlockingChain;
    private final GraphQlClientInterceptor.SubscriptionChain subscriptionChain;
    private final @Nullable Duration blockingTimeout;

    DefaultGraphQlClient(DocumentSource documentSource, SyncGraphQlClientInterceptor.Chain blockingChain, Scheduler scheduler, @Nullable Duration blockingTimeout) {
        Assert.notNull((Object)documentSource, (String)"DocumentSource is required");
        Assert.notNull((Object)blockingChain, (String)"Execution chain is required");
        Assert.notNull((Object)scheduler, (String)"Scheduler is required");
        this.documentSource = documentSource;
        this.blockingChain = blockingChain;
        this.nonBlockingChain = DefaultGraphQlClient.adaptToNonBlockingChain(blockingChain, scheduler);
        this.subscriptionChain = request -> Flux.error((Throwable)new IllegalStateException("Subscriptions on supported"));
        this.blockingTimeout = blockingTimeout;
    }

    DefaultGraphQlClient(DocumentSource documentSource, GraphQlClientInterceptor.Chain nonBlockingChain, GraphQlClientInterceptor.SubscriptionChain subscriptionChain, @Nullable Duration blockingTimeout) {
        Assert.notNull((Object)documentSource, (String)"DocumentSource is required");
        Assert.notNull((Object)nonBlockingChain, (String)"Execution chain is required");
        Assert.notNull((Object)subscriptionChain, (String)"Subscription execution chain is required");
        this.documentSource = documentSource;
        this.blockingChain = DefaultGraphQlClient.adaptToBlockingChain(nonBlockingChain, blockingTimeout);
        this.nonBlockingChain = nonBlockingChain;
        this.subscriptionChain = subscriptionChain;
        this.blockingTimeout = blockingTimeout;
    }

    private static GraphQlClientInterceptor.Chain adaptToNonBlockingChain(SyncGraphQlClientInterceptor.Chain blockingChain, Scheduler scheduler) {
        return request -> Mono.fromCallable(() -> blockingChain.next(request)).subscribeOn(scheduler);
    }

    private static SyncGraphQlClientInterceptor.Chain adaptToBlockingChain(GraphQlClientInterceptor.Chain executeChain, @Nullable Duration blockingTimeout) {
        return request -> blockingTimeout != null ? (ClientGraphQlResponse)executeChain.next(request).block(blockingTimeout) : (ClientGraphQlResponse)executeChain.next(request).block();
    }

    @Override
    public GraphQlClient.RequestSpec document(String document) {
        return new DefaultRequestSpec((Mono<String>)Mono.just((Object)document));
    }

    @Override
    public GraphQlClient.RequestSpec documentName(String name) {
        return new DefaultRequestSpec(this.documentSource.getDocument(name));
    }

    public GraphQlClient.Builder<?> mutate() {
        throw new UnsupportedOperationException();
    }

    private final class DefaultRequestSpec
    implements GraphQlClient.RequestSpec {
        private final Mono<String> documentMono;
        private @Nullable String operationName;
        private final Map<String, Object> variables = new LinkedHashMap<String, Object>();
        private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
        private final Map<String, Object> extensions = new LinkedHashMap<String, Object>();

        DefaultRequestSpec(Mono<String> documentMono) {
            Assert.notNull(documentMono, (String)"'document' is required");
            this.documentMono = documentMono;
        }

        @Override
        public DefaultRequestSpec operationName(@Nullable String operationName) {
            this.operationName = operationName;
            return this;
        }

        @Override
        public DefaultRequestSpec variable(String name, @Nullable Object value) {
            this.variables.put(name, value);
            return this;
        }

        @Override
        public GraphQlClient.RequestSpec variables(Map<String, Object> variables) {
            this.variables.putAll(variables);
            return this;
        }

        @Override
        public GraphQlClient.RequestSpec extension(String name, @Nullable Object value) {
            this.extensions.put(name, value);
            return this;
        }

        @Override
        public GraphQlClient.RequestSpec extensions(Map<String, Object> extensions) {
            this.extensions.putAll(extensions);
            return this;
        }

        @Override
        public GraphQlClient.RequestSpec attribute(String name, Object value) {
            this.attributes.put(name, value);
            return this;
        }

        @Override
        public GraphQlClient.RequestSpec attributes(Consumer<Map<String, Object>> attributesConsumer) {
            attributesConsumer.accept(this.attributes);
            return this;
        }

        @Override
        public GraphQlClient.RetrieveSyncSpec retrieveSync(String path) {
            ClientGraphQlResponse response = this.executeSync();
            return new DefaultRetrieveSyncSpec(response, path);
        }

        @Override
        public GraphQlClient.RetrieveSpec retrieve(String path) {
            return new DefaultRetrieveSpec(this.execute(), path);
        }

        @Override
        public GraphQlClient.RetrieveSubscriptionSpec retrieveSubscription(String path) {
            return new DefaultRetrieveSubscriptionSpec(this.executeSubscription(), path);
        }

        @Override
        public ClientGraphQlResponse executeSync() {
            Mono<ClientGraphQlRequest> mono = this.initRequest();
            ClientGraphQlRequest request = DefaultGraphQlClient.this.blockingTimeout != null ? (ClientGraphQlRequest)mono.block(DefaultGraphQlClient.this.blockingTimeout) : (ClientGraphQlRequest)mono.block();
            return DefaultGraphQlClient.this.blockingChain.next(request);
        }

        @Override
        public Mono<ClientGraphQlResponse> execute() {
            return this.initRequest().flatMap(request -> DefaultGraphQlClient.this.nonBlockingChain.next((ClientGraphQlRequest)request).onErrorResume(ex -> !(ex instanceof GraphQlClientException), ex -> Mono.error((Throwable)((Object)new GraphQlTransportException((Throwable)ex, (GraphQlRequest)request)))));
        }

        @Override
        public Flux<ClientGraphQlResponse> executeSubscription() {
            return this.initRequest().flatMapMany(request -> DefaultGraphQlClient.this.subscriptionChain.next((ClientGraphQlRequest)request).onErrorResume(ex -> !(ex instanceof GraphQlClientException), ex -> Mono.error((Throwable)((Object)new GraphQlTransportException((Throwable)ex, (GraphQlRequest)request)))));
        }

        private Mono<ClientGraphQlRequest> initRequest() {
            return this.documentMono.map(document -> new DefaultClientGraphQlRequest((String)document, this.operationName, this.variables, this.extensions, this.attributes));
        }
    }

    private static class DefaultRetrieveSubscriptionSpec
    extends RetrieveSpecSupport
    implements GraphQlClient.RetrieveSubscriptionSpec {
        private final Flux<ClientGraphQlResponse> responseFlux;

        DefaultRetrieveSubscriptionSpec(Flux<ClientGraphQlResponse> responseFlux, String path) {
            super(path);
            this.responseFlux = responseFlux;
        }

        @Override
        public <D> Flux<D> toEntity(Class<D> entityType) {
            return this.responseFlux.mapNotNull(this::getValidField).mapNotNull(field -> field.toEntity(entityType));
        }

        @Override
        public <D> Flux<D> toEntity(ParameterizedTypeReference<D> entityType) {
            return this.responseFlux.mapNotNull(this::getValidField).mapNotNull(field -> field.toEntity(entityType));
        }

        @Override
        public <D> Flux<List<D>> toEntityList(Class<D> elementType) {
            return this.responseFlux.map(response -> {
                ClientResponseField field = this.getValidField((ClientGraphQlResponse)response);
                return field != null ? field.toEntityList(elementType) : Collections.emptyList();
            });
        }

        @Override
        public <D> Flux<List<D>> toEntityList(ParameterizedTypeReference<D> elementType) {
            return this.responseFlux.map(response -> {
                ClientResponseField field = this.getValidField((ClientGraphQlResponse)response);
                return field != null ? field.toEntityList(elementType) : Collections.emptyList();
            });
        }
    }

    private static class DefaultRetrieveSpec
    extends RetrieveSpecSupport
    implements GraphQlClient.RetrieveSpec {
        private final Mono<ClientGraphQlResponse> responseMono;

        DefaultRetrieveSpec(Mono<ClientGraphQlResponse> responseMono, String path) {
            super(path);
            this.responseMono = responseMono;
        }

        @Override
        public <D> Mono<D> toEntity(Class<D> entityType) {
            return this.responseMono.mapNotNull(this::getValidField).mapNotNull(field -> field.toEntity(entityType));
        }

        @Override
        public <D> Mono<D> toEntity(ParameterizedTypeReference<D> entityType) {
            return this.responseMono.mapNotNull(this::getValidField).mapNotNull(field -> field.toEntity(entityType));
        }

        @Override
        public <D> Mono<List<D>> toEntityList(Class<D> elementType) {
            return this.responseMono.map(response -> {
                ClientResponseField field = this.getValidField((ClientGraphQlResponse)response);
                return field != null ? field.toEntityList(elementType) : Collections.emptyList();
            });
        }

        @Override
        public <D> Mono<List<D>> toEntityList(ParameterizedTypeReference<D> elementType) {
            return this.responseMono.map(response -> {
                ClientResponseField field = this.getValidField((ClientGraphQlResponse)response);
                return field != null ? field.toEntityList(elementType) : Collections.emptyList();
            });
        }
    }

    private static class DefaultRetrieveSyncSpec
    extends RetrieveSpecSupport
    implements GraphQlClient.RetrieveSyncSpec {
        private final ClientGraphQlResponse response;

        DefaultRetrieveSyncSpec(ClientGraphQlResponse response, String path) {
            super(path);
            this.response = response;
        }

        @Override
        public <D> @Nullable D toEntity(Class<D> entityType) {
            ClientResponseField field = this.getValidField(this.response);
            return field != null ? (D)field.toEntity(entityType) : null;
        }

        @Override
        public <D> @Nullable D toEntity(ParameterizedTypeReference<D> entityType) {
            ClientResponseField field = this.getValidField(this.response);
            return field != null ? (D)field.toEntity(entityType) : null;
        }

        @Override
        public <D> List<D> toEntityList(Class<D> elementType) {
            ClientResponseField field = this.getValidField(this.response);
            return field != null ? field.toEntityList(elementType) : Collections.emptyList();
        }

        @Override
        public <D> List<D> toEntityList(ParameterizedTypeReference<D> elementType) {
            ClientResponseField field = this.getValidField(this.response);
            return field != null ? field.toEntityList(elementType) : Collections.emptyList();
        }
    }

    private static class RetrieveSpecSupport {
        private final String path;

        protected RetrieveSpecSupport(String path) {
            this.path = path;
        }

        protected @Nullable ClientResponseField getValidField(ClientGraphQlResponse response) {
            ClientResponseField field = response.field(this.path);
            if (!response.isValid() || !field.getErrors().isEmpty()) {
                throw new FieldAccessException(((DefaultClientGraphQlResponse)response).getRequest(), response, field);
            }
            return field.getValue() != null ? field : null;
        }
    }
}

