/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.ClassPathResource;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.client.DefaultClientGraphQlResponse;
import org.springframework.graphql.client.DefaultGraphQlClient;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.graphql.client.HttpMessageConverterDelegate;
import org.springframework.graphql.client.SyncGraphQlClientInterceptor;
import org.springframework.graphql.client.SyncGraphQlTransport;
import org.springframework.graphql.client.json.GraphQlJackson2Module;
import org.springframework.graphql.client.json.GraphQlJacksonModule;
import org.springframework.graphql.support.CachingDocumentSource;
import org.springframework.graphql.support.DocumentSource;
import org.springframework.graphql.support.ResourceDocumentSource;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.JacksonJsonHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.json.JsonMapper;

public abstract class AbstractGraphQlClientSyncBuilder<B extends AbstractGraphQlClientSyncBuilder<B>>
implements GraphQlClient.SyncBuilder<B> {
    protected static final boolean jacksonPresent = ClassUtils.isPresent((String)"tools.jackson.databind.ObjectMapper", (ClassLoader)AbstractGraphQlClientSyncBuilder.class.getClassLoader());
    protected static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)AbstractGraphQlClientSyncBuilder.class.getClassLoader());
    private final List<SyncGraphQlClientInterceptor> interceptors = new ArrayList<SyncGraphQlClientInterceptor>();
    private DocumentSource documentSource;
    private @Nullable HttpMessageConverter<Object> jsonConverter;
    private Scheduler scheduler = Schedulers.boundedElastic();
    private @Nullable Duration blockingTimeout;

    protected AbstractGraphQlClientSyncBuilder() {
        this.documentSource = AbstractGraphQlClientSyncBuilder.initDocumentSource();
    }

    private static DocumentSource initDocumentSource() {
        return new CachingDocumentSource(new ResourceDocumentSource(Collections.singletonList(new ClassPathResource("graphql-documents/")), ResourceDocumentSource.FILE_EXTENSIONS));
    }

    @Override
    public B interceptor(SyncGraphQlClientInterceptor ... interceptors) {
        Collections.addAll(this.interceptors, interceptors);
        return (B)this.self();
    }

    @Override
    public B interceptors(Consumer<List<SyncGraphQlClientInterceptor>> interceptorsConsumer) {
        interceptorsConsumer.accept(this.interceptors);
        return (B)this.self();
    }

    @Override
    public B documentSource(DocumentSource documentSource) {
        this.documentSource = documentSource;
        return (B)this.self();
    }

    @Override
    public B scheduler(Scheduler scheduler) {
        Assert.notNull((Object)scheduler, (String)"Scheduler is required");
        this.scheduler = scheduler;
        return (B)this.self();
    }

    @Override
    public B blockingTimeout(@Nullable Duration blockingTimeout) {
        this.blockingTimeout = blockingTimeout;
        return (B)this.self();
    }

    private <T extends B> T self() {
        return (T)this;
    }

    protected void setJsonConverter(HttpMessageConverter<Object> converter) {
        this.jsonConverter = converter;
    }

    protected GraphQlClient buildGraphQlClient(SyncGraphQlTransport transport) {
        if (jacksonPresent) {
            this.jsonConverter = this.jsonConverter == null ? DefaultJacksonConverter.initialize() : this.jsonConverter;
        } else if (jackson2Present) {
            this.jsonConverter = this.jsonConverter == null ? DefaultJackson2Converter.initialize() : this.jsonConverter;
        }
        return new DefaultGraphQlClient(this.documentSource, this.createExecuteChain(transport), this.scheduler, this.blockingTimeout);
    }

    protected Consumer<AbstractGraphQlClientSyncBuilder<?>> getBuilderInitializer() {
        return builder -> {
            builder.interceptors((T interceptorList) -> interceptorList.addAll(this.interceptors));
            builder.documentSource(this.documentSource);
            builder.setJsonConverter(this.getJsonConverter());
        };
    }

    private SyncGraphQlClientInterceptor.Chain createExecuteChain(SyncGraphQlTransport transport) {
        HttpMessageConverterDelegate.HttpMessageConverterEncoder encoder = HttpMessageConverterDelegate.asEncoder(this.getJsonConverter());
        HttpMessageConverterDelegate.HttpMessageConverterDecoder decoder = HttpMessageConverterDelegate.asDecoder(this.getJsonConverter());
        SyncGraphQlClientInterceptor.Chain chain = request -> {
            GraphQlResponse response = transport.execute(request);
            return new DefaultClientGraphQlResponse(request, response, encoder, decoder);
        };
        return this.interceptors.stream().reduce(SyncGraphQlClientInterceptor::andThen).map(i -> request -> i.intercept(request, chain)).orElse(chain);
    }

    private HttpMessageConverter<Object> getJsonConverter() {
        Assert.notNull(this.jsonConverter, (String)"jsonConverter has not been set");
        return this.jsonConverter;
    }

    private static final class DefaultJacksonConverter {
        private DefaultJacksonConverter() {
        }

        static HttpMessageConverter<Object> initialize() {
            JsonMapper jsonMapper = ((JsonMapper.Builder)JsonMapper.builder().addModule((JacksonModule)new GraphQlJacksonModule())).build();
            return new JacksonJsonHttpMessageConverter((tools.jackson.databind.ObjectMapper)jsonMapper);
        }
    }

    private static final class DefaultJackson2Converter {
        private DefaultJackson2Converter() {
        }

        static HttpMessageConverter<Object> initialize() {
            ObjectMapper objectMapper = Jackson2ObjectMapperBuilder.json().modulesToInstall(new Module[]{new GraphQlJackson2Module()}).build();
            return new MappingJackson2HttpMessageConverter(objectMapper);
        }
    }
}

