/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.GraphQLArgument;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.ResolvableType;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.repository.query.QueryByExampleExecutor;
import org.springframework.data.repository.query.ReactiveQueryByExampleExecutor;
import org.springframework.data.util.TypeInformation;
import org.springframework.graphql.data.GraphQlArgumentBinder;
import org.springframework.graphql.data.pagination.CursorStrategy;
import org.springframework.graphql.data.query.AutoRegistrationRuntimeWiringConfigurer;
import org.springframework.graphql.data.query.PropertySelection;
import org.springframework.graphql.data.query.RepositoryUtils;
import org.springframework.graphql.data.query.ScrollSubrange;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.graphql.execution.SelfDescribingDataFetcher;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class QueryByExampleDataFetcher<T> {
    private static final Log logger = LogFactory.getLog(QueryByExampleDataFetcher.class);
    private final TypeInformation<T> domainType;
    private final GraphQlArgumentBinder argumentBinder;

    QueryByExampleDataFetcher(TypeInformation<T> domainType) {
        this.domainType = domainType;
        this.argumentBinder = new GraphQlArgumentBinder();
    }

    public String getDescription() {
        return "QueryByExampleDataFetcher<" + this.domainType.getType().getName() + ">";
    }

    protected Example<T> buildExample(DataFetchingEnvironment environment) throws BindException {
        String name = QueryByExampleDataFetcher.getArgumentName(environment);
        ResolvableType targetType = ResolvableType.forClass((Class)this.domainType.getType());
        return Example.of((Object)this.argumentBinder.bind(environment, name, targetType));
    }

    @Nullable
    private static String getArgumentName(DataFetchingEnvironment environment) {
        String name;
        Map arguments = environment.getArguments();
        List definedArguments = environment.getFieldDefinition().getArguments();
        if (definedArguments.size() == 1 && arguments.get(name = ((GraphQLArgument)definedArguments.get(0)).getName()) instanceof Map) {
            return name;
        }
        return null;
    }

    protected boolean requiresProjection(Class<?> resultType) {
        return !resultType.equals(this.domainType.getType());
    }

    protected Collection<String> buildPropertyPaths(DataFetchingFieldSelectionSet selection, Class<?> resultType) {
        if (this.domainType.getType().equals(resultType) || this.domainType.getType().isAssignableFrom(resultType) || this.domainType.isSubTypeOf(resultType)) {
            return PropertySelection.create(this.domainType, selection).toList();
        }
        return Collections.emptyList();
    }

    public String toString() {
        return this.getDescription();
    }

    public static <T> Builder<T, T> builder(QueryByExampleExecutor<T> executor) {
        return new Builder(executor, RepositoryUtils.getDomainType(executor));
    }

    public static <T> ReactiveBuilder<T, T> builder(ReactiveQueryByExampleExecutor<T> executor) {
        return new ReactiveBuilder(executor, RepositoryUtils.getDomainType(executor));
    }

    public static RuntimeWiringConfigurer autoRegistrationConfigurer(List<QueryByExampleExecutor<?>> executors, List<ReactiveQueryByExampleExecutor<?>> reactiveExecutors) {
        return QueryByExampleDataFetcher.autoRegistrationConfigurer(executors, reactiveExecutors, null, null);
    }

    public static RuntimeWiringConfigurer autoRegistrationConfigurer(List<QueryByExampleExecutor<?>> executors, List<ReactiveQueryByExampleExecutor<?>> reactiveExecutors, @Nullable CursorStrategy<ScrollPosition> cursorStrategy, @Nullable ScrollSubrange defaultScrollSubrange) {
        Object builder;
        String typeName;
        HashMap<String, AutoRegistrationRuntimeWiringConfigurer.DataFetcherFactory> factories = new HashMap<String, AutoRegistrationRuntimeWiringConfigurer.DataFetcherFactory>();
        for (QueryByExampleExecutor<?> queryByExampleExecutor : executors) {
            typeName = RepositoryUtils.getGraphQlTypeName(queryByExampleExecutor);
            if (typeName == null) continue;
            builder = QueryByExampleDataFetcher.customize(queryByExampleExecutor, QueryByExampleDataFetcher.builder(queryByExampleExecutor).cursorStrategy(cursorStrategy).defaultScrollSubrange(defaultScrollSubrange));
            factories.put(typeName, new AutoRegistrationRuntimeWiringConfigurer.DataFetcherFactory((Builder)builder){
                final /* synthetic */ Builder val$builder;
                {
                    this.val$builder = builder;
                }

                @Override
                public DataFetcher<?> single() {
                    return this.val$builder.single();
                }

                @Override
                public DataFetcher<?> many() {
                    return this.val$builder.many();
                }

                @Override
                public DataFetcher<?> scrollable() {
                    return this.val$builder.scrollable();
                }
            });
        }
        for (ReactiveQueryByExampleExecutor reactiveQueryByExampleExecutor : reactiveExecutors) {
            typeName = RepositoryUtils.getGraphQlTypeName(reactiveQueryByExampleExecutor);
            if (typeName == null) continue;
            builder = QueryByExampleDataFetcher.customize(reactiveQueryByExampleExecutor, QueryByExampleDataFetcher.builder(reactiveQueryByExampleExecutor).cursorStrategy(cursorStrategy).defaultScrollSubrange(defaultScrollSubrange));
            factories.put(typeName, new AutoRegistrationRuntimeWiringConfigurer.DataFetcherFactory((ReactiveBuilder)builder){
                final /* synthetic */ ReactiveBuilder val$builder;
                {
                    this.val$builder = reactiveBuilder;
                }

                @Override
                public DataFetcher<?> single() {
                    return this.val$builder.single();
                }

                @Override
                public DataFetcher<?> many() {
                    return this.val$builder.many();
                }

                @Override
                public DataFetcher<?> scrollable() {
                    return this.val$builder.scrollable();
                }
            });
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Auto-registration candidate typeNames " + String.valueOf(factories.keySet())));
        }
        return new AutoRegistrationRuntimeWiringConfigurer(factories);
    }

    private static Builder customize(QueryByExampleExecutor<?> executor, Builder builder) {
        if (executor instanceof QueryByExampleBuilderCustomizer) {
            QueryByExampleBuilderCustomizer customizer = (QueryByExampleBuilderCustomizer)executor;
            return customizer.customize(builder);
        }
        return builder;
    }

    private static ReactiveBuilder customize(ReactiveQueryByExampleExecutor<?> executor, ReactiveBuilder builder) {
        if (executor instanceof ReactiveQueryByExampleBuilderCustomizer) {
            ReactiveQueryByExampleBuilderCustomizer customizer = (ReactiveQueryByExampleBuilderCustomizer)executor;
            return customizer.customize(builder);
        }
        return builder;
    }

    public static class Builder<T, R> {
        private final QueryByExampleExecutor<T> executor;
        private final TypeInformation<T> domainType;
        private final Class<R> resultType;
        @Nullable
        private final CursorStrategy<ScrollPosition> cursorStrategy;
        @Nullable
        private final Integer defaultScrollCount;
        @Nullable
        private final Function<Boolean, ScrollPosition> defaultScrollPosition;
        private final Sort sort;

        Builder(QueryByExampleExecutor<T> executor, Class<R> domainType) {
            this(executor, TypeInformation.of(domainType), domainType, null, null, null, Sort.unsorted());
        }

        Builder(QueryByExampleExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, @Nullable CursorStrategy<ScrollPosition> cursorStrategy, @Nullable Integer defaultScrollCount, @Nullable Function<Boolean, ScrollPosition> defaultScrollPosition, Sort sort) {
            this.executor = executor;
            this.domainType = domainType;
            this.resultType = resultType;
            this.cursorStrategy = cursorStrategy;
            this.defaultScrollCount = defaultScrollCount;
            this.defaultScrollPosition = defaultScrollPosition;
            this.sort = sort;
        }

        public <P> Builder<T, P> projectAs(Class<P> projectionType) {
            Assert.notNull(projectionType, (String)"Projection type must not be null");
            return new Builder<T, P>(this.executor, this.domainType, projectionType, this.cursorStrategy, this.defaultScrollCount, this.defaultScrollPosition, this.sort);
        }

        public Builder<T, R> cursorStrategy(@Nullable CursorStrategy<ScrollPosition> cursorStrategy) {
            return new Builder<T, R>(this.executor, this.domainType, this.resultType, cursorStrategy, this.defaultScrollCount, this.defaultScrollPosition, this.sort);
        }

        public Builder<T, R> defaultScrollSubrange(int defaultCount, Function<Boolean, ScrollPosition> defaultPosition) {
            return new Builder<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy, defaultCount, defaultPosition, this.sort);
        }

        @Deprecated(since="1.2.5", forRemoval=true)
        public Builder<T, R> defaultScrollSubrange(@Nullable ScrollSubrange defaultSubrange) {
            return new Builder<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy, defaultSubrange != null ? Integer.valueOf(defaultSubrange.count().getAsInt()) : null, defaultSubrange != null ? forward -> (ScrollPosition)defaultSubrange.position().get() : null, this.sort);
        }

        public Builder<T, R> sortBy(Sort sort) {
            Assert.notNull((Object)sort, (String)"Sort must not be null");
            return new Builder<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy, this.defaultScrollCount, this.defaultScrollPosition, sort);
        }

        public DataFetcher<R> single() {
            return new SingleEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.sort);
        }

        public DataFetcher<Iterable<R>> many() {
            return new ManyEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.sort);
        }

        public DataFetcher<Iterable<R>> scrollable() {
            return new ScrollableEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy != null ? this.cursorStrategy : RepositoryUtils.defaultCursorStrategy(), this.defaultScrollCount != null ? this.defaultScrollCount : RepositoryUtils.defaultScrollCount(), this.defaultScrollPosition != null ? this.defaultScrollPosition : RepositoryUtils.defaultScrollPosition(), this.sort);
        }
    }

    public static class ReactiveBuilder<T, R> {
        private final ReactiveQueryByExampleExecutor<T> executor;
        private final TypeInformation<T> domainType;
        private final Class<R> resultType;
        @Nullable
        private final CursorStrategy<ScrollPosition> cursorStrategy;
        @Nullable
        private final Integer defaultScrollCount;
        @Nullable
        private final Function<Boolean, ScrollPosition> defaultScrollPosition;
        private final Sort sort;

        ReactiveBuilder(ReactiveQueryByExampleExecutor<T> executor, Class<R> domainType) {
            this(executor, TypeInformation.of(domainType), domainType, null, null, null, Sort.unsorted());
        }

        ReactiveBuilder(ReactiveQueryByExampleExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, @Nullable CursorStrategy<ScrollPosition> cursorStrategy, @Nullable Integer defaultScrollCount, @Nullable Function<Boolean, ScrollPosition> defaultScrollPosition, Sort sort) {
            this.executor = executor;
            this.domainType = domainType;
            this.resultType = resultType;
            this.cursorStrategy = cursorStrategy;
            this.defaultScrollCount = defaultScrollCount;
            this.defaultScrollPosition = defaultScrollPosition;
            this.sort = sort;
        }

        public <P> ReactiveBuilder<T, P> projectAs(Class<P> projectionType) {
            Assert.notNull(projectionType, (String)"Projection type must not be null");
            return new ReactiveBuilder<T, P>(this.executor, this.domainType, projectionType, this.cursorStrategy, this.defaultScrollCount, this.defaultScrollPosition, this.sort);
        }

        public ReactiveBuilder<T, R> cursorStrategy(@Nullable CursorStrategy<ScrollPosition> cursorStrategy) {
            return new ReactiveBuilder<T, R>(this.executor, this.domainType, this.resultType, cursorStrategy, this.defaultScrollCount, this.defaultScrollPosition, this.sort);
        }

        public ReactiveBuilder<T, R> defaultScrollSubrange(int defaultCount, Function<Boolean, ScrollPosition> defaultPosition) {
            return new ReactiveBuilder<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy, defaultCount, defaultPosition, this.sort);
        }

        @Deprecated(since="1.2.5", forRemoval=true)
        public ReactiveBuilder<T, R> defaultScrollSubrange(@Nullable ScrollSubrange defaultSubrange) {
            return new ReactiveBuilder<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy, defaultSubrange != null ? Integer.valueOf(defaultSubrange.count().getAsInt()) : null, defaultSubrange != null ? forward -> (ScrollPosition)defaultSubrange.position().get() : null, this.sort);
        }

        public ReactiveBuilder<T, R> sortBy(Sort sort) {
            Assert.notNull((Object)sort, (String)"Sort must not be null");
            return new ReactiveBuilder<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy, this.defaultScrollCount, this.defaultScrollPosition, sort);
        }

        public DataFetcher<Mono<R>> single() {
            return new ReactiveSingleEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.sort);
        }

        public DataFetcher<Flux<R>> many() {
            return new ReactiveManyEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.sort);
        }

        public DataFetcher<Mono<Iterable<R>>> scrollable() {
            return new ReactiveScrollableEntityFetcher<T, R>(this.executor, this.domainType, this.resultType, this.cursorStrategy != null ? this.cursorStrategy : RepositoryUtils.defaultCursorStrategy(), this.defaultScrollCount != null ? this.defaultScrollCount : RepositoryUtils.defaultScrollCount(), this.defaultScrollPosition != null ? this.defaultScrollPosition : RepositoryUtils.defaultScrollPosition(), this.sort);
        }
    }

    public static interface QueryByExampleBuilderCustomizer<T> {
        public Builder<T, ?> customize(Builder<T, ?> var1);
    }

    public static interface ReactiveQueryByExampleBuilderCustomizer<T> {
        public ReactiveBuilder<T, ?> customize(ReactiveBuilder<T, ?> var1);
    }

    private static class ReactiveScrollableEntityFetcher<T, R>
    extends QueryByExampleDataFetcher<T>
    implements SelfDescribingDataFetcher<Mono<Iterable<R>>> {
        private final ReactiveQueryByExampleExecutor<T> executor;
        private final Class<R> resultType;
        private final ResolvableType scrollableResultType;
        private final CursorStrategy<ScrollPosition> cursorStrategy;
        private final int defaultCount;
        private final Function<Boolean, ScrollPosition> defaultPosition;
        private final Sort sort;

        ReactiveScrollableEntityFetcher(ReactiveQueryByExampleExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, CursorStrategy<ScrollPosition> cursorStrategy, int defaultCount, Function<Boolean, ScrollPosition> defaultPosition, Sort sort) {
            super(domainType);
            Assert.notNull(cursorStrategy, (String)"CursorStrategy is required");
            Assert.notNull(defaultPosition, (String)"'defaultPosition' is required");
            this.executor = executor;
            this.resultType = resultType;
            this.scrollableResultType = ResolvableType.forClassWithGenerics(Iterable.class, (Class[])new Class[]{resultType});
            this.cursorStrategy = cursorStrategy;
            this.defaultCount = defaultCount;
            this.defaultPosition = defaultPosition;
            this.sort = sort;
        }

        @Override
        public ResolvableType getReturnType() {
            return ResolvableType.forClassWithGenerics(Mono.class, (ResolvableType[])new ResolvableType[]{this.scrollableResultType});
        }

        public Mono<Iterable<R>> get(DataFetchingEnvironment env) throws BindException {
            return (Mono)this.executor.findBy(this.buildExample(env), query -> {
                FluentQuery.ReactiveFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(this.resultType) ? queryToUse.as(this.resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), this.resultType));
                ScrollSubrange range = RepositoryUtils.getScrollSubrange(env, this.cursorStrategy);
                int count = range.count().orElse(this.defaultCount);
                ScrollPosition position = range.position().isPresent() ? (ScrollPosition)range.position().get() : this.defaultPosition.apply(range.forward());
                return queryToUse.limit(count).scroll(position).map(Function.identity());
            });
        }
    }

    private static class ReactiveManyEntityFetcher<T, R>
    extends QueryByExampleDataFetcher<T>
    implements SelfDescribingDataFetcher<Flux<R>> {
        private final ReactiveQueryByExampleExecutor<T> executor;
        private final Class<R> resultType;
        private final Sort sort;

        ReactiveManyEntityFetcher(ReactiveQueryByExampleExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort) {
            super(domainType);
            this.executor = executor;
            this.resultType = resultType;
            this.sort = sort;
        }

        @Override
        public ResolvableType getReturnType() {
            return ResolvableType.forClassWithGenerics(Flux.class, (Class[])new Class[]{this.resultType});
        }

        public Flux<R> get(DataFetchingEnvironment env) throws BindException {
            return (Flux)this.executor.findBy(this.buildExample(env), query -> {
                FluentQuery.ReactiveFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(this.resultType) ? queryToUse.as(this.resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), this.resultType));
                return queryToUse.all();
            });
        }
    }

    private static class ReactiveSingleEntityFetcher<T, R>
    extends QueryByExampleDataFetcher<T>
    implements SelfDescribingDataFetcher<Mono<R>> {
        private final ReactiveQueryByExampleExecutor<T> executor;
        private final Class<R> resultType;
        private final Sort sort;

        ReactiveSingleEntityFetcher(ReactiveQueryByExampleExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort) {
            super(domainType);
            this.executor = executor;
            this.resultType = resultType;
            this.sort = sort;
        }

        @Override
        public ResolvableType getReturnType() {
            return ResolvableType.forClassWithGenerics(Mono.class, (Class[])new Class[]{this.resultType});
        }

        public Mono<R> get(DataFetchingEnvironment env) throws BindException {
            return (Mono)this.executor.findBy(this.buildExample(env), query -> {
                FluentQuery.ReactiveFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(this.resultType) ? queryToUse.as(this.resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), this.resultType));
                return queryToUse.first();
            });
        }
    }

    private static class ScrollableEntityFetcher<T, R>
    extends ManyEntityFetcher<T, R> {
        private final CursorStrategy<ScrollPosition> cursorStrategy;
        private final int defaultCount;
        private final Function<Boolean, ScrollPosition> defaultPosition;
        private final ResolvableType scrollableResultType;

        ScrollableEntityFetcher(QueryByExampleExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, CursorStrategy<ScrollPosition> cursorStrategy, int defaultCount, Function<Boolean, ScrollPosition> defaultPosition, Sort sort) {
            super(executor, domainType, resultType, sort);
            Assert.notNull(cursorStrategy, (String)"CursorStrategy is required");
            Assert.notNull(defaultPosition, (String)"'defaultPosition' is required");
            this.cursorStrategy = cursorStrategy;
            this.defaultCount = defaultCount;
            this.defaultPosition = defaultPosition;
            this.scrollableResultType = ResolvableType.forClassWithGenerics(Window.class, (Class[])new Class[]{resultType});
        }

        @Override
        public ResolvableType getReturnType() {
            return ResolvableType.forClassWithGenerics(Iterable.class, (ResolvableType[])new ResolvableType[]{this.scrollableResultType});
        }

        @Override
        protected Iterable<R> getResult(FluentQuery.FetchableFluentQuery<R> queryToUse, DataFetchingEnvironment env) {
            ScrollSubrange range = RepositoryUtils.getScrollSubrange(env, this.cursorStrategy);
            int count = range.count().orElse(this.defaultCount);
            ScrollPosition position = range.position().isPresent() ? (ScrollPosition)range.position().get() : this.defaultPosition.apply(range.forward());
            return queryToUse.limit(count).scroll(position);
        }
    }

    private static class ManyEntityFetcher<T, R>
    extends QueryByExampleDataFetcher<T>
    implements SelfDescribingDataFetcher<Iterable<R>> {
        private final QueryByExampleExecutor<T> executor;
        private final Class<R> resultType;
        private final Sort sort;

        ManyEntityFetcher(QueryByExampleExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort) {
            super(domainType);
            this.executor = executor;
            this.resultType = resultType;
            this.sort = sort;
        }

        @Override
        public ResolvableType getReturnType() {
            return ResolvableType.forClassWithGenerics(Iterable.class, (Class[])new Class[]{this.resultType});
        }

        public Iterable<R> get(DataFetchingEnvironment env) throws BindException {
            return (Iterable)this.executor.findBy(this.buildExample(env), query -> {
                FluentQuery.FetchableFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(this.resultType) ? queryToUse.as(this.resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), this.resultType));
                return this.getResult(queryToUse, env);
            });
        }

        protected Iterable<R> getResult(FluentQuery.FetchableFluentQuery<R> queryToUse, DataFetchingEnvironment env) {
            return queryToUse.all();
        }
    }

    private static class SingleEntityFetcher<T, R>
    extends QueryByExampleDataFetcher<T>
    implements SelfDescribingDataFetcher<R> {
        private final QueryByExampleExecutor<T> executor;
        private final Class<R> resultType;
        private final Sort sort;

        SingleEntityFetcher(QueryByExampleExecutor<T> executor, TypeInformation<T> domainType, Class<R> resultType, Sort sort) {
            super(domainType);
            this.executor = executor;
            this.resultType = resultType;
            this.sort = sort;
        }

        @Override
        public ResolvableType getReturnType() {
            return ResolvableType.forClass(this.resultType);
        }

        public R get(DataFetchingEnvironment env) throws BindException {
            return ((Optional)this.executor.findBy(this.buildExample(env), query -> {
                Class<R> resultType;
                FluentQuery.FetchableFluentQuery queryToUse = query;
                if (this.sort.isSorted()) {
                    queryToUse = queryToUse.sortBy(this.sort);
                }
                queryToUse = this.requiresProjection(resultType = this.resultType) ? queryToUse.as(resultType) : queryToUse.project(this.buildPropertyPaths(env.getSelectionSet(), resultType));
                return queryToUse.first();
            })).orElse(null);
        }
    }
}

