/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.format.FormatterRegistrar;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolverComposite;
import org.springframework.graphql.data.method.annotation.support.AnnotatedControllerExceptionResolver;
import org.springframework.graphql.data.method.annotation.support.HandlerDataFetcherExceptionResolver;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class AnnotatedControllerDetectionSupport<M>
implements ApplicationContextAware,
InitializingBean {
    protected static final boolean springSecurityPresent = ClassUtils.isPresent((String)"org.springframework.security.core.context.SecurityContext", (ClassLoader)AnnotatedControllerDetectionSupport.class.getClassLoader());
    private static final boolean virtualThreadsPresent = ReflectionUtils.findMethod(Thread.class, (String)"ofVirtual") != null;
    private static final String SCOPED_TARGET_NAME_PREFIX = "scopedTarget.";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final FormattingConversionService conversionService = new DefaultFormattingConversionService();
    private boolean fallBackOnDirectFieldAccess;
    @Nullable
    private AnnotatedControllerExceptionResolver exceptionResolver;
    @Nullable
    private Executor executor;
    private Predicate<HandlerMethod> blockingMethodPredicate = virtualThreadsPresent ? new BlockingHandlerMethodPredicate() : method -> false;
    @Nullable
    private HandlerMethodArgumentResolverComposite argumentResolvers;
    @Nullable
    private ApplicationContext applicationContext;

    public void addFormatterRegistrar(FormatterRegistrar registrar) {
        registrar.registerFormatters((FormatterRegistry)this.conversionService);
    }

    protected FormattingConversionService getConversionService() {
        return this.conversionService;
    }

    public void setFallBackOnDirectFieldAccess(boolean fallBackOnDirectFieldAccess) {
        this.fallBackOnDirectFieldAccess = fallBackOnDirectFieldAccess;
    }

    protected boolean isFallBackOnDirectFieldAccess() {
        return this.fallBackOnDirectFieldAccess;
    }

    public HandlerDataFetcherExceptionResolver getExceptionResolver() {
        Assert.notNull((Object)this.exceptionResolver, (String)"afterPropertiesSet not called yet");
        return this.exceptionResolver;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Nullable
    public Executor getExecutor() {
        return this.executor;
    }

    public void setBlockingMethodPredicate(@Nullable Predicate<HandlerMethod> predicate) {
        this.blockingMethodPredicate = predicate != null ? predicate : handlerMethod -> false;
    }

    protected HandlerMethodArgumentResolverComposite getArgumentResolvers() {
        Assert.notNull((Object)this.argumentResolvers, (String)"afterPropertiesSet not called yet");
        return this.argumentResolvers;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Nullable
    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    protected final ApplicationContext obtainApplicationContext() {
        Assert.state((this.applicationContext != null ? 1 : 0) != 0, (String)"No ApplicationContext");
        return this.applicationContext;
    }

    public void afterPropertiesSet() {
        this.argumentResolvers = this.initArgumentResolvers();
        this.exceptionResolver = new AnnotatedControllerExceptionResolver(this.argumentResolvers);
        if (this.getApplicationContext() != null) {
            this.exceptionResolver.registerControllerAdvice(this.getApplicationContext());
        }
    }

    protected abstract HandlerMethodArgumentResolverComposite initArgumentResolvers();

    protected Set<M> detectHandlerMethods() {
        LinkedHashSet results = new LinkedHashSet();
        ApplicationContext context = this.obtainApplicationContext();
        for (String beanName : context.getBeanNamesForType(Object.class)) {
            Class beanType;
            block3: {
                if (beanName.startsWith(SCOPED_TARGET_NAME_PREFIX)) continue;
                beanType = null;
                try {
                    beanType = context.getType(beanName);
                }
                catch (Throwable ex) {
                    if (!this.logger.isTraceEnabled()) break block3;
                    this.logger.trace((Object)("Could not resolve type for bean '" + beanName + "'"), ex);
                }
            }
            if (beanType == null || !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)beanType, Controller.class)) continue;
            Class beanClass = context.getType(beanName);
            this.findHandlerMethods(beanName, beanClass).forEach(info -> this.addHandlerMethod(info, results));
        }
        return results;
    }

    private Collection<M> findHandlerMethods(Object handler, @Nullable Class<?> handlerClass) {
        if (handlerClass == null) {
            return Collections.emptyList();
        }
        Class userClass = ClassUtils.getUserClass(handlerClass);
        Map map = MethodIntrospector.selectMethods((Class)userClass, method -> this.getMappingInfo(method, handler, userClass));
        return map.values();
    }

    @Nullable
    protected abstract M getMappingInfo(Method var1, Object var2, Class<?> var3);

    protected HandlerMethod createHandlerMethod(Method originalMethod, Object handler, Class<?> handlerType) {
        HandlerMethod handlerMethod;
        Method method = AopUtils.selectInvocableMethod((Method)originalMethod, handlerType);
        if (handler instanceof String) {
            String beanName = (String)handler;
            handlerMethod = new HandlerMethod(beanName, (BeanFactory)this.obtainApplicationContext().getAutowireCapableBeanFactory(), method);
        } else {
            handlerMethod = new HandlerMethod(handler, method);
        }
        return handlerMethod;
    }

    private void addHandlerMethod(M info, Set<M> results) {
        Assert.state((this.exceptionResolver != null ? 1 : 0) != 0, (String)"afterPropertiesSet not called");
        HandlerMethod handlerMethod = this.getHandlerMethod(info);
        M existing = results.stream().filter(o -> o.equals(info)).findFirst().orElse(null);
        if (existing != null && !this.getHandlerMethod(existing).equals(handlerMethod)) {
            throw new IllegalStateException("Ambiguous mapping. Cannot map '" + String.valueOf(handlerMethod.getBean()) + "' method \n" + String.valueOf(handlerMethod) + "\n: There is already '" + String.valueOf(this.getHandlerMethod(existing).getBean()) + "' bean method\n" + String.valueOf(existing) + " mapped.");
        }
        results.add(info);
        this.exceptionResolver.registerController(handlerMethod.getBeanType());
    }

    protected abstract HandlerMethod getHandlerMethod(M var1);

    protected boolean shouldInvokeAsync(HandlerMethod handlerMethod) {
        SchedulingTaskExecutor ste;
        Executor executor;
        return this.blockingMethodPredicate.test(handlerMethod) && this.executor != null && (!((executor = this.executor) instanceof SchedulingTaskExecutor) || !(ste = (SchedulingTaskExecutor)executor).prefersShortLivedTasks());
    }

    private static final class BlockingHandlerMethodPredicate
    implements Predicate<HandlerMethod> {
        private BlockingHandlerMethodPredicate() {
        }

        @Override
        public boolean test(HandlerMethod hm) {
            Class returnType = hm.getReturnType().getParameterType();
            return ReactiveAdapterRegistry.getSharedInstance().getAdapter(returnType) == null && !KotlinDetector.isSuspendingFunction((Method)hm.getMethod());
        }
    }
}

