/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.execution.ExecutionIdProvider;
import graphql.execution.instrumentation.dataloader.EmptyDataLoaderRegistryInstance;
import io.micrometer.context.ContextSnapshotFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.dataloader.DataLoaderRegistry;
import org.springframework.graphql.ExecutionGraphQlRequest;
import org.springframework.graphql.ExecutionGraphQlResponse;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.execution.ContextSnapshotFactoryHelper;
import org.springframework.graphql.execution.DataLoaderRegistrar;
import org.springframework.graphql.execution.GraphQlSource;
import org.springframework.graphql.support.DefaultExecutionGraphQlResponse;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Mono;

public class DefaultExecutionGraphQlService
implements ExecutionGraphQlService {
    private static final boolean belowGraphQlJava22 = ClassUtils.isPresent((String)"graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationState", (ClassLoader)ExecutionGraphQlService.class.getClassLoader());
    private static final BiFunction<ExecutionInput, ExecutionInput.Builder, ExecutionInput> RESET_EXECUTION_ID_CONFIGURER = (executionInput, builder) -> builder.executionId(null).build();
    private final GraphQlSource graphQlSource;
    private final List<DataLoaderRegistrar> dataLoaderRegistrars = new ArrayList<DataLoaderRegistrar>();
    private boolean hasDataLoaderRegistrations;
    private final boolean isDefaultExecutionIdProvider;
    private final Object emptyDataLoaderRegistryInstance;

    public DefaultExecutionGraphQlService(GraphQlSource graphQlSource) {
        this.graphQlSource = graphQlSource;
        this.isDefaultExecutionIdProvider = graphQlSource.graphQl().getIdProvider() == ExecutionIdProvider.DEFAULT_EXECUTION_ID_PROVIDER;
        this.emptyDataLoaderRegistryInstance = belowGraphQlJava22 ? DataLoaderRegistry21Initializer.getInstance() : DataLoaderRegistry22Initializer.getInstance();
    }

    public void addDataLoaderRegistrar(DataLoaderRegistrar registrar) {
        this.dataLoaderRegistrars.add(registrar);
        this.hasDataLoaderRegistrations = this.hasDataLoaderRegistrations || DefaultExecutionGraphQlService.hasRegistrations(registrar);
    }

    private static boolean hasRegistrations(DataLoaderRegistrar registrar) {
        DataLoaderRegistry registry = DataLoaderRegistry.newRegistry().build();
        registrar.registerDataLoaders(registry, GraphQLContext.newContext().build());
        return !registry.getDataLoaders().isEmpty();
    }

    @Override
    public final Mono<ExecutionGraphQlResponse> execute(ExecutionGraphQlRequest request) {
        return Mono.deferContextual(contextView -> {
            if (!this.isDefaultExecutionIdProvider && request.getExecutionId() == null) {
                request.configureExecutionInput(RESET_EXECUTION_ID_CONFIGURER);
            }
            ExecutionInput executionInput = request.toExecutionInput();
            ContextSnapshotFactory factory = ContextSnapshotFactoryHelper.getInstance(contextView);
            GraphQLContext graphQLContext = executionInput.getGraphQLContext();
            ContextSnapshotFactoryHelper.saveInstance(factory, graphQLContext);
            factory.captureFrom(new Object[]{contextView}).updateContext((Object)graphQLContext);
            ExecutionInput updatedExecutionInput = this.hasDataLoaderRegistrations ? this.registerDataLoaders(executionInput) : executionInput;
            return Mono.fromFuture((CompletableFuture)this.graphQlSource.graphQl().executeAsync(updatedExecutionInput)).map(result -> new DefaultExecutionGraphQlResponse(updatedExecutionInput, (ExecutionResult)result));
        });
    }

    private ExecutionInput registerDataLoaders(ExecutionInput executionInput) {
        GraphQLContext graphQLContext = executionInput.getGraphQLContext();
        DataLoaderRegistry existingRegistry = executionInput.getDataLoaderRegistry();
        if (existingRegistry == this.emptyDataLoaderRegistryInstance) {
            DataLoaderRegistry newRegistry = DataLoaderRegistry.newRegistry().build();
            this.applyDataLoaderRegistrars(newRegistry, graphQLContext);
            executionInput = executionInput.transform(builder -> builder.dataLoaderRegistry(newRegistry));
        } else {
            this.applyDataLoaderRegistrars(existingRegistry, graphQLContext);
        }
        return executionInput;
    }

    private void applyDataLoaderRegistrars(DataLoaderRegistry registry, GraphQLContext graphQLContext) {
        this.dataLoaderRegistrars.forEach(registrar -> registrar.registerDataLoaders(registry, graphQLContext));
    }

    private static final class DataLoaderRegistry21Initializer {
        public static final String CLASS_NAME = "graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationState";

        private DataLoaderRegistry21Initializer() {
        }

        public static Object getInstance() {
            try {
                Field field = ReflectionUtils.findField(Class.forName(CLASS_NAME), (String)"EMPTY_DATALOADER_REGISTRY");
                return ReflectionUtils.getField((Field)field, null);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static final class DataLoaderRegistry22Initializer {
        private DataLoaderRegistry22Initializer() {
        }

        public static Object getInstance() {
            return EmptyDataLoaderRegistryInstance.EMPTY_DATALOADER_REGISTRY;
        }
    }
}

