/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import io.micrometer.context.ContextSnapshot;
import io.micrometer.context.ContextSnapshotFactory;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.graphql.execution.CompositeSubscriptionExceptionResolver;
import org.springframework.graphql.execution.ContextSnapshotFactoryHelper;
import org.springframework.graphql.execution.SubscriptionExceptionResolver;
import org.springframework.graphql.execution.SubscriptionPublisherException;
import org.springframework.graphql.execution.TypeVisitorHelper;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ContextDataFetcherDecorator
implements DataFetcher<Object> {
    private final DataFetcher<?> delegate;
    private final boolean subscription;
    private final SubscriptionExceptionResolver subscriptionExceptionResolver;

    private ContextDataFetcherDecorator(DataFetcher<?> delegate, boolean subscription, SubscriptionExceptionResolver subscriptionExceptionResolver) {
        Assert.notNull(delegate, (String)"'delegate' DataFetcher is required");
        Assert.notNull((Object)subscriptionExceptionResolver, (String)"'subscriptionExceptionResolver' is required");
        this.delegate = delegate;
        this.subscription = subscription;
        this.subscriptionExceptionResolver = subscriptionExceptionResolver;
    }

    public Object get(DataFetchingEnvironment env) throws Exception {
        ContextSnapshot contextSnapshot;
        GraphQLContext graphQlContext = env.getGraphQlContext();
        ContextSnapshotFactory snapshotFactory = ContextSnapshotFactoryHelper.getInstance(graphQlContext);
        Object object = env.getLocalContext();
        if (object instanceof GraphQLContext) {
            GraphQLContext localContext = (GraphQLContext)object;
            contextSnapshot = snapshotFactory.captureFrom(new Object[]{graphQlContext, localContext});
        } else {
            contextSnapshot = snapshotFactory.captureFrom(new Object[]{graphQlContext});
        }
        ContextSnapshot snapshot = contextSnapshot;
        Object value = snapshot.wrap(() -> this.delegate.get(env)).call();
        if (this.subscription) {
            Assert.state((boolean)(value instanceof Publisher), (String)"Expected Publisher for a subscription");
            Flux flux = Flux.from((Publisher)((Publisher)value)).onErrorResume(exception -> {
                if (exception instanceof SubscriptionPublisherException) {
                    return Mono.error((Throwable)exception);
                }
                return this.subscriptionExceptionResolver.resolveException((Throwable)exception).flatMap(errors -> Mono.error((Throwable)((Object)new SubscriptionPublisherException((List<GraphQLError>)errors, (Throwable)exception))));
            });
            return flux.contextWrite(arg_0 -> ((ContextSnapshot)snapshot).updateContext(arg_0));
        }
        if (value instanceof Flux) {
            value = ((Flux)value).collectList();
        }
        if (value instanceof Mono) {
            Mono valueMono = (Mono)value;
            value = valueMono.contextWrite(arg_0 -> ((ContextSnapshot)snapshot).updateContext(arg_0)).toFuture();
        }
        return value;
    }

    static GraphQLTypeVisitor createVisitor(List<SubscriptionExceptionResolver> resolvers) {
        return new ContextTypeVisitor(resolvers);
    }

    private static final class ContextTypeVisitor
    extends GraphQLTypeVisitorStub {
        private final SubscriptionExceptionResolver exceptionResolver;

        private ContextTypeVisitor(List<SubscriptionExceptionResolver> resolvers) {
            this.exceptionResolver = new CompositeSubscriptionExceptionResolver(resolvers);
        }

        public TraversalControl visitGraphQLFieldDefinition(GraphQLFieldDefinition fieldDefinition, TraverserContext<GraphQLSchemaElement> context) {
            GraphQLFieldsContainer parent;
            FieldCoordinates fieldCoordinates;
            TypeVisitorHelper visitorHelper = (TypeVisitorHelper)context.getVarFromParents(TypeVisitorHelper.class);
            GraphQLCodeRegistry.Builder codeRegistry = (GraphQLCodeRegistry.Builder)context.getVarFromParents(GraphQLCodeRegistry.Builder.class);
            DataFetcher dataFetcher = codeRegistry.getDataFetcher(fieldCoordinates = FieldCoordinates.coordinates((GraphQLFieldsContainer)(parent = (GraphQLFieldsContainer)context.getParentNode()), (GraphQLFieldDefinition)fieldDefinition), fieldDefinition);
            if (this.applyDecorator(dataFetcher)) {
                boolean handlesSubscription = visitorHelper.isSubscriptionType((GraphQLNamedType)parent);
                dataFetcher = new ContextDataFetcherDecorator(dataFetcher, handlesSubscription, this.exceptionResolver);
                codeRegistry.dataFetcher(fieldCoordinates, dataFetcher);
            }
            return TraversalControl.CONTINUE;
        }

        private boolean applyDecorator(DataFetcher<?> dataFetcher) {
            Class<?> type = dataFetcher.getClass();
            String packageName = type.getPackage().getName();
            if (packageName.startsWith("graphql.")) {
                return type.getSimpleName().startsWith("DataFetcherFactories") || packageName.startsWith("graphql.validation");
            }
            return true;
        }
    }
}

