/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.federation;

import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionStepInfo;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DelegatingDataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionException;
import org.springframework.graphql.data.federation.EntityHandlerMethod;
import org.springframework.graphql.data.federation.RepresentationException;
import org.springframework.graphql.data.federation.RepresentationNotResolvedException;
import org.springframework.graphql.data.method.annotation.support.HandlerDataFetcherExceptionResolver;
import org.springframework.graphql.execution.ErrorType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

final class EntitiesDataFetcher
implements DataFetcher<Mono<DataFetcherResult<List<Object>>>> {
    private final Map<String, EntityHandlerMethod> handlerMethods;
    private final HandlerDataFetcherExceptionResolver exceptionResolver;

    EntitiesDataFetcher(Map<String, EntityHandlerMethod> handlerMethods, HandlerDataFetcherExceptionResolver resolver) {
        this.handlerMethods = new LinkedHashMap<String, EntityHandlerMethod>(handlerMethods);
        this.exceptionResolver = resolver;
    }

    public Mono<DataFetcherResult<List<Object>>> get(DataFetchingEnvironment environment) {
        List representations = (List)environment.getArgument("representations");
        HashSet<String> batched = new HashSet<String>();
        ArrayList<Object> monoList = new ArrayList<Object>();
        for (int index = 0; index < representations.size(); ++index) {
            Map map = (Map)representations.get(index);
            Object v = map.get("__typename");
            if (!(v instanceof String)) {
                RepresentationException ex = new RepresentationException(map, "Missing \"__typename\" argument");
                monoList.add(this.resolveException(ex, environment, null, index));
                continue;
            }
            String typename = (String)v;
            EntityHandlerMethod handlerMethod = this.handlerMethods.get(typename);
            if (handlerMethod == null) {
                RepresentationException ex = new RepresentationException(map, "No entity fetcher");
                monoList.add(this.resolveException(ex, environment, null, index));
                continue;
            }
            if (!handlerMethod.isBatchHandlerMethod()) {
                monoList.add(this.invokeEntityMethod(environment, handlerMethod, map, index));
                continue;
            }
            if (batched.contains(typename)) {
                monoList.add(Mono.just(Collections.emptyMap()));
                continue;
            }
            EntityBatchDelegate batchDelegate = new EntityBatchDelegate(environment, handlerMethod, typename);
            monoList.add(batchDelegate.invokeEntityBatchMethod());
            batched.add(typename);
        }
        return Mono.zip(monoList, Arrays::asList).map(EntitiesDataFetcher::toDataFetcherResult);
    }

    private Mono<Object> invokeEntityMethod(DataFetchingEnvironment env, EntityHandlerMethod handlerMethod, Map<String, Object> map, int index) {
        return handlerMethod.getEntity(env, map).switchIfEmpty(Mono.error((Throwable)new RepresentationNotResolvedException(map, handlerMethod))).onErrorResume(ex -> this.resolveException((Throwable)ex, env, handlerMethod, index));
    }

    private Mono<Object> resolveException(Throwable ex, DataFetchingEnvironment env, @Nullable EntityHandlerMethod handlerMethod, int index) {
        Throwable theEx = ex instanceof CompletionException ? ex.getCause() : ex;
        IndexedDataFetchingEnvironment theEnv = new IndexedDataFetchingEnvironment(env, index);
        Object handler = handlerMethod != null ? handlerMethod.getBean() : null;
        return this.exceptionResolver.resolveException(theEx, (DataFetchingEnvironment)theEnv, handler).map(ErrorContainer::new).switchIfEmpty(Mono.fromCallable(() -> this.lambda$resolveException$1(theEx, (DataFetchingEnvironment)theEnv))).cast(Object.class);
    }

    private ErrorContainer createDefaultError(Throwable ex, DataFetchingEnvironment env) {
        ErrorType errorType;
        if (ex instanceof RepresentationException) {
            RepresentationException representationEx = (RepresentationException)ex;
            errorType = representationEx.getErrorType();
        } else {
            errorType = ErrorType.INTERNAL_ERROR;
        }
        ErrorType errorType2 = errorType;
        return new ErrorContainer(GraphqlErrorBuilder.newError((DataFetchingEnvironment)env).errorType((ErrorClassification)errorType2).message(ex.getMessage(), new Object[0]).build());
    }

    private static DataFetcherResult<List<Object>> toDataFetcherResult(List<Object> entities) {
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        for (int i = 0; i < entities.size(); ++i) {
            Object entity = entities.get(i);
            if (entity instanceof EntityBatchDelegate) {
                EntityBatchDelegate delegate = (EntityBatchDelegate)entity;
                delegate.processResults(entities, errors);
            }
            if (!(entity instanceof ErrorContainer)) continue;
            ErrorContainer errorContainer = (ErrorContainer)entity;
            errors.addAll(errorContainer.errors());
            entities.set(i, null);
        }
        return DataFetcherResult.newResult().data(entities).errors(errors).build();
    }

    private /* synthetic */ ErrorContainer lambda$resolveException$1(Throwable theEx, DataFetchingEnvironment theEnv) throws Exception {
        return this.createDefaultError(theEx, theEnv);
    }

    private class EntityBatchDelegate {
        private final DataFetchingEnvironment environment;
        private final EntityHandlerMethod handlerMethod;
        private final List<Map<String, Object>> representations = new ArrayList<Map<String, Object>>();
        private final List<Integer> indexes = new ArrayList<Integer>();
        @Nullable
        private List<?> resultList;

        EntityBatchDelegate(DataFetchingEnvironment env, EntityHandlerMethod handlerMethod, String typeName) {
            this.environment = env;
            this.handlerMethod = handlerMethod;
            List maps = (List)env.getArgument("representations");
            for (int i = 0; i < maps.size(); ++i) {
                Map map = (Map)maps.get(i);
                if (!typeName.equals(map.get("__typename"))) continue;
                this.representations.add(map);
                this.indexes.add(i);
            }
        }

        Mono<Object> invokeEntityBatchMethod() {
            return this.handlerMethod.getEntities(this.environment, this.representations).mapNotNull(result -> ((List)result).isEmpty() ? null : result).switchIfEmpty(Mono.defer(this::handleEmptyResult)).onErrorResume(this::handleErrorResult).map(result -> {
                this.resultList = (List)result;
                return this;
            });
        }

        Mono<Object> handleEmptyResult() {
            ArrayList<Mono<Object>> exceptions = new ArrayList<Mono<Object>>(this.indexes.size());
            for (int i = 0; i < this.indexes.size(); ++i) {
                Map<String, Object> map = this.representations.get(i);
                RepresentationNotResolvedException ex = new RepresentationNotResolvedException(map, this.handlerMethod);
                exceptions.add(EntitiesDataFetcher.this.resolveException(ex, this.environment, this.handlerMethod, this.indexes.get(i)));
            }
            return Mono.zip(exceptions, Arrays::asList);
        }

        Mono<List<Object>> handleErrorResult(Throwable ex) {
            ArrayList<Mono<Object>> list = new ArrayList<Mono<Object>>();
            for (Integer index : this.indexes) {
                list.add(EntitiesDataFetcher.this.resolveException(ex, this.environment, this.handlerMethod, index));
            }
            return Mono.zip(list, Arrays::asList);
        }

        void processResults(List<Object> entities, List<GraphQLError> errors) {
            Assert.state((this.resultList != null ? 1 : 0) != 0, (String)"Expected resultList");
            for (int i = 0; i < this.resultList.size(); ++i) {
                Object entity = this.resultList.get(i);
                if (entity instanceof ErrorContainer) {
                    ErrorContainer errorContainer = (ErrorContainer)entity;
                    errors.addAll(errorContainer.errors());
                    entity = null;
                }
                entities.set(this.indexes.get(i), entity);
            }
        }
    }

    private static class IndexedDataFetchingEnvironment
    extends DelegatingDataFetchingEnvironment {
        private final ExecutionStepInfo executionStepInfo;

        IndexedDataFetchingEnvironment(DataFetchingEnvironment env, int index) {
            super(env);
            this.executionStepInfo = ExecutionStepInfo.newExecutionStepInfo((ExecutionStepInfo)env.getExecutionStepInfo()).path(env.getExecutionStepInfo().getPath().segment(index)).build();
        }

        public ExecutionStepInfo getExecutionStepInfo() {
            return this.executionStepInfo;
        }
    }

    private record ErrorContainer(List<GraphQLError> errors) {
        ErrorContainer(GraphQLError error) {
            this(Collections.singletonList(error));
        }
    }
}

