/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webflux;

import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import java.util.Map;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.graphql.server.support.GraphQlWebSocketMessage;
import org.springframework.http.MediaType;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.util.Assert;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;

final class CodecDelegate {
    private static final ResolvableType MESSAGE_TYPE = ResolvableType.forClass(GraphQlWebSocketMessage.class);
    private final Decoder<?> decoder;
    private final Encoder<?> encoder;

    CodecDelegate(CodecConfigurer codecConfigurer) {
        Assert.notNull((Object)codecConfigurer, (String)"CodecConfigurer is required");
        this.decoder = CodecDelegate.findJsonDecoder(codecConfigurer);
        this.encoder = CodecDelegate.findJsonEncoder(codecConfigurer);
    }

    private static Decoder<?> findJsonDecoder(CodecConfigurer configurer) {
        return configurer.getReaders().stream().filter(reader -> reader.canRead(MESSAGE_TYPE, MediaType.APPLICATION_JSON)).map(reader -> ((DecoderHttpMessageReader)reader).getDecoder()).findFirst().orElseThrow(() -> new IllegalArgumentException("No JSON Decoder"));
    }

    private static Encoder<?> findJsonEncoder(CodecConfigurer configurer) {
        return configurer.getWriters().stream().filter(writer -> writer.canWrite(MESSAGE_TYPE, MediaType.APPLICATION_JSON)).map(writer -> ((EncoderHttpMessageWriter)writer).getEncoder()).findFirst().orElseThrow(() -> new IllegalArgumentException("No JSON Encoder"));
    }

    public <T> WebSocketMessage encode(WebSocketSession session, GraphQlWebSocketMessage message) {
        DataBuffer buffer = this.encoder.encodeValue((Object)message, session.bufferFactory(), MESSAGE_TYPE, MimeTypeUtils.APPLICATION_JSON, null);
        return new WebSocketMessage(WebSocketMessage.Type.TEXT, buffer);
    }

    public GraphQlWebSocketMessage decode(WebSocketMessage webSocketMessage) {
        DataBuffer buffer = DataBufferUtils.retain((DataBuffer)webSocketMessage.getPayload());
        return (GraphQlWebSocketMessage)this.decoder.decode(buffer, MESSAGE_TYPE, null, null);
    }

    public WebSocketMessage encodeConnectionAck(WebSocketSession session, Object ackPayload) {
        return this.encode(session, GraphQlWebSocketMessage.connectionAck(ackPayload));
    }

    public WebSocketMessage encodeNext(WebSocketSession session, String id, Map<String, Object> responseMap) {
        return this.encode(session, GraphQlWebSocketMessage.next(id, responseMap));
    }

    public WebSocketMessage encodeError(WebSocketSession session, String id, Throwable ex) {
        GraphQLError error = GraphqlErrorBuilder.newError().message(ex.getMessage(), new Object[0]).build();
        return this.encode(session, GraphQlWebSocketMessage.error(id, error));
    }

    public WebSocketMessage encodeComplete(WebSocketSession session, String id) {
        return this.encode(session, GraphQlWebSocketMessage.complete(id));
    }
}

