/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.net.URI;
import java.util.function.Consumer;
import org.springframework.graphql.test.tester.AbstractDelegatingGraphQlTester;
import org.springframework.graphql.test.tester.AbstractGraphQlTesterBuilder;
import org.springframework.graphql.test.tester.EncoderDecoderMappingProvider;
import org.springframework.graphql.test.tester.GraphQlTester;
import org.springframework.graphql.test.tester.HttpGraphQlTester;
import org.springframework.graphql.test.tester.WebTestClientTransport;
import org.springframework.http.HttpHeaders;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;
import org.springframework.web.util.UriComponentsBuilder;

final class DefaultHttpGraphQlTesterBuilder
extends AbstractGraphQlTesterBuilder<DefaultHttpGraphQlTesterBuilder>
implements HttpGraphQlTester.Builder<DefaultHttpGraphQlTesterBuilder> {
    private final WebTestClient.Builder webTestClientBuilder;

    DefaultHttpGraphQlTesterBuilder(WebTestClient.Builder clientBuilder) {
        this.webTestClientBuilder = clientBuilder;
    }

    @Override
    public DefaultHttpGraphQlTesterBuilder url(String url) {
        this.webTestClientBuilder.baseUrl(url);
        return this;
    }

    @Override
    public DefaultHttpGraphQlTesterBuilder url(URI url) {
        DefaultUriBuilderFactory factory = new DefaultUriBuilderFactory(UriComponentsBuilder.fromUri((URI)url));
        this.webTestClientBuilder.uriBuilderFactory((UriBuilderFactory)factory);
        return this;
    }

    @Override
    public DefaultHttpGraphQlTesterBuilder header(String name, String ... values) {
        this.webTestClientBuilder.defaultHeader(name, values);
        return this;
    }

    @Override
    public DefaultHttpGraphQlTesterBuilder headers(Consumer<HttpHeaders> headersConsumer) {
        this.webTestClientBuilder.defaultHeaders(headersConsumer);
        return this;
    }

    @Override
    public DefaultHttpGraphQlTesterBuilder codecConfigurer(Consumer<CodecConfigurer> codecConsumer) {
        this.webTestClientBuilder.codecs(codecConsumer::accept);
        return this;
    }

    @Override
    public DefaultHttpGraphQlTesterBuilder webTestClient(Consumer<WebTestClient.Builder> configurer) {
        configurer.accept(this.webTestClientBuilder);
        return this;
    }

    @Override
    public HttpGraphQlTester build() {
        this.registerJsonPathMappingProvider();
        WebTestClient client = this.webTestClientBuilder.build();
        GraphQlTester tester = super.buildGraphQlTester(new WebTestClientTransport(client));
        return new DefaultHttpGraphQlTester(tester, client, this.getBuilderInitializer());
    }

    private void registerJsonPathMappingProvider() {
        this.webTestClientBuilder.codecs(codecConfigurer -> this.configureJsonPathConfig(config -> {
            EncoderDecoderMappingProvider provider = new EncoderDecoderMappingProvider((CodecConfigurer)codecConfigurer);
            return config.mappingProvider((MappingProvider)provider);
        }));
    }

    private static final class DefaultHttpGraphQlTester
    extends AbstractDelegatingGraphQlTester
    implements HttpGraphQlTester {
        private final WebTestClient webTestClient;
        private final Consumer<AbstractGraphQlTesterBuilder<?>> builderInitializer;

        private DefaultHttpGraphQlTester(GraphQlTester graphQlTester, WebTestClient webTestClient, Consumer<AbstractGraphQlTesterBuilder<?>> builderInitializer) {
            super(graphQlTester);
            this.webTestClient = webTestClient;
            this.builderInitializer = builderInitializer;
        }

        @Override
        public DefaultHttpGraphQlTesterBuilder mutate() {
            DefaultHttpGraphQlTesterBuilder builder = new DefaultHttpGraphQlTesterBuilder(this.webTestClient.mutate());
            this.builderInitializer.accept(builder);
            return builder;
        }
    }
}

