/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.graphql.client.GraphQlClientInterceptor;
import org.springframework.graphql.test.tester.DefaultWebSocketGraphQlTesterBuilder;
import org.springframework.graphql.test.tester.WebGraphQlTester;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.core.publisher.Mono;

public interface WebSocketGraphQlTester
extends WebGraphQlTester {
    public Mono<Void> start();

    public Mono<Void> stop();

    @Override
    public Builder<?> mutate();

    public static WebSocketGraphQlTester create(URI url, WebSocketClient webSocketClient) {
        return WebSocketGraphQlTester.builder(url, webSocketClient).build();
    }

    public static Builder<?> builder(String url, WebSocketClient webSocketClient) {
        return new DefaultWebSocketGraphQlTesterBuilder(url, webSocketClient);
    }

    public static Builder<?> builder(URI url, WebSocketClient webSocketClient) {
        return new DefaultWebSocketGraphQlTesterBuilder(url, webSocketClient);
    }

    public static interface Builder<B extends Builder<B>>
    extends WebGraphQlTester.Builder<B> {
        public B interceptor(GraphQlClientInterceptor ... var1);

        public B interceptors(Consumer<List<GraphQlClientInterceptor>> var1);

        @Override
        public WebSocketGraphQlTester build();
    }
}

