/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.test;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.test.ApplicationModuleTest;
import org.springframework.modulith.test.DefaultPublishedEvents;
import org.springframework.modulith.test.ModuleTestExecution;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;

class ModuleContextCustomizerFactory
implements ContextCustomizerFactory {
    ModuleContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        ApplicationModuleTest moduleTest = (ApplicationModuleTest)AnnotatedElementUtils.getMergedAnnotation(testClass, ApplicationModuleTest.class);
        return moduleTest == null ? null : new ModuleContextCustomizer(testClass);
    }

    static class ModuleContextCustomizer
    implements ContextCustomizer {
        private static final Logger LOGGER = LoggerFactory.getLogger(ModuleContextCustomizer.class);
        private static final String BEAN_NAME = ModuleTestExecution.class.getName();
        private final Supplier<ModuleTestExecution> execution;

        private ModuleContextCustomizer(Class<?> testClass) {
            this.execution = ModuleTestExecution.of(testClass);
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
            ModuleTestExecution testExecution = this.execution.get();
            ModuleContextCustomizer.logModules(testExecution);
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            beanFactory.registerSingleton(BEAN_NAME, (Object)testExecution);
            DefaultPublishedEvents events = new DefaultPublishedEvents();
            beanFactory.registerSingleton(events.getClass().getName(), (Object)events);
            context.addApplicationListener((ApplicationListener)events);
        }

        private static void logModules(ModuleTestExecution execution) {
            List<ApplicationModule> dependencies;
            Set sharedModules;
            ApplicationModule module = execution.getModule();
            ApplicationModules modules = execution.getModules();
            String moduleName = module.getDisplayName();
            String bootstrapMode = execution.getBootstrapMode().name();
            String message = "Bootstrapping @%s for %s in mode %s (%s)\u2026".formatted(ApplicationModuleTest.class.getName(), moduleName, bootstrapMode, modules.getSource());
            LOGGER.info(message);
            LOGGER.info("");
            Arrays.stream(module.toString(modules).split("\n")).forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
            List<ApplicationModule> extraIncludes = execution.getExtraIncludes();
            if (!extraIncludes.isEmpty()) {
                ModuleContextCustomizer.logHeadline("Extra includes:");
                LOGGER.info("> " + extraIncludes.stream().map(ApplicationModule::getName).collect(Collectors.joining(", ")));
            }
            if (!(sharedModules = modules.getSharedModules()).isEmpty()) {
                ModuleContextCustomizer.logHeadline("Shared modules:");
                LOGGER.info("> " + sharedModules.stream().map(ApplicationModule::getName).collect(Collectors.joining(", ")));
            }
            if (!(dependencies = execution.getDependencies()).isEmpty() || !sharedModules.isEmpty()) {
                ModuleContextCustomizer.logHeadline("Included dependencies:");
                Stream<ApplicationModule> dependenciesPlusMissingSharedOnes = Stream.concat(dependencies.stream(), sharedModules.stream().filter(it -> !dependencies.contains(it)));
                dependenciesPlusMissingSharedOnes.map(it -> it.toString(modules)).forEach(it -> {
                    LOGGER.info("");
                    Arrays.stream(it.split("\n")).forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
                });
            }
            LOGGER.info("");
        }

        private static void logHeadline(String headline) {
            ModuleContextCustomizer.logHeadline(headline, () -> {});
        }

        private static void logHeadline(String headline, Runnable additional) {
            LOGGER.info("");
            LOGGER.info(headline);
            additional.run();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ModuleContextCustomizer)) {
                return false;
            }
            ModuleContextCustomizer that = (ModuleContextCustomizer)obj;
            return Objects.equals(this.execution, that.execution);
        }

        public int hashCode() {
            return Objects.hash(this.execution);
        }
    }
}

