/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.repository.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.repository.query.ParameterMetadata;
import org.springframework.data.relational.repository.query.ParameterMetadataProvider;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class CriteriaFactory {
    private final ParameterMetadataProvider parameterMetadataProvider;

    public CriteriaFactory(ParameterMetadataProvider parameterMetadataProvider) {
        Assert.notNull((Object)parameterMetadataProvider, (String)"Parameter metadata provider must not be null");
        this.parameterMetadataProvider = parameterMetadataProvider;
    }

    public Criteria createCriteria(Part part) {
        Part.Type type = part.getType();
        String propertyName = part.getProperty().toDotPath();
        Class propertyType = part.getProperty().getType();
        Criteria.CriteriaStep criteriaStep = Criteria.where(propertyName);
        if (type == Part.Type.IS_NULL || type == Part.Type.IS_NOT_NULL) {
            return part.getType() == Part.Type.IS_NULL ? criteriaStep.isNull() : criteriaStep.isNotNull();
        }
        if (type == Part.Type.TRUE || type == Part.Type.FALSE) {
            return part.getType() == Part.Type.TRUE ? criteriaStep.isTrue() : criteriaStep.isFalse();
        }
        switch (type) {
            case BETWEEN: {
                Object geValue = this.requireNextValue(part, "geValue");
                Object leValue = this.requireNextValue(part, "leValue");
                return criteriaStep.between(geValue, leValue);
            }
            case AFTER: 
            case GREATER_THAN: {
                Object value = this.requireNextValue(part);
                return criteriaStep.greaterThan(value);
            }
            case GREATER_THAN_EQUAL: {
                Object value = this.requireNextValue(part);
                return criteriaStep.greaterThanOrEquals(value);
            }
            case BEFORE: 
            case LESS_THAN: {
                Object value = this.requireNextValue(part);
                return criteriaStep.lessThan(value);
            }
            case LESS_THAN_EQUAL: {
                Object value = this.requireNextValue(part);
                return criteriaStep.lessThanOrEquals(value);
            }
            case IN: 
            case NOT_IN: {
                Object value = this.requireNextValue(part);
                Criteria criteria = part.getType() == Part.Type.IN ? criteriaStep.in(CriteriaFactory.asCollection(value)) : criteriaStep.notIn(CriteriaFactory.asCollection(value));
                return criteria.ignoreCase(this.shouldIgnoreCase(part) && this.checkCanUpperCase(part, part.getProperty().getType()));
            }
            case STARTING_WITH: 
            case ENDING_WITH: 
            case CONTAINING: 
            case NOT_CONTAINING: 
            case LIKE: 
            case NOT_LIKE: {
                ParameterMetadata paramMetadata = this.parameterMetadataProvider.next(part);
                Object value = paramMetadata.value();
                Assert.state((value != null ? 1 : 0) != 0, (String)"value must not be null");
                Criteria criteria = part.getType() == Part.Type.NOT_LIKE || part.getType() == Part.Type.NOT_CONTAINING ? criteriaStep.notLike(value) : criteriaStep.like(value);
                return criteria.ignoreCase(this.shouldIgnoreCase(part) && this.checkCanUpperCase(part, propertyType, paramMetadata.type()));
            }
            case SIMPLE_PROPERTY: {
                ParameterMetadata paramMetadata = this.parameterMetadataProvider.next(part);
                if (paramMetadata.value() == null) {
                    return criteriaStep.isNull();
                }
                return criteriaStep.is(paramMetadata.value()).ignoreCase(this.shouldIgnoreCase(part) && this.checkCanUpperCase(part, propertyType, paramMetadata.type()));
            }
            case NEGATING_SIMPLE_PROPERTY: {
                ParameterMetadata paramMetadata = this.parameterMetadataProvider.next(part);
                Object value = paramMetadata.value();
                Assert.state((value != null ? 1 : 0) != 0, (String)"value must not be null");
                return criteriaStep.not(value).ignoreCase(this.shouldIgnoreCase(part) && this.checkCanUpperCase(part, propertyType, paramMetadata.type()));
            }
        }
        throw new IllegalArgumentException("Unsupported keyword " + String.valueOf(type));
    }

    private Object requireNextValue(Part part, String geValue_must_not_be_null) {
        Object value = this.parameterMetadataProvider.next(part).value();
        Assert.state((value != null ? 1 : 0) != 0, (String)(geValue_must_not_be_null + " must not be null"));
        return value;
    }

    private Object requireNextValue(Part part) {
        return this.requireNextValue(part, "value");
    }

    private boolean shouldIgnoreCase(Part part) {
        return part.shouldIgnoreCase() == Part.IgnoreCaseType.ALWAYS || part.shouldIgnoreCase() == Part.IgnoreCaseType.WHEN_POSSIBLE;
    }

    private boolean checkCanUpperCase(Part part, Class<?> ... expressionTypes) {
        Assert.notEmpty((Object[])expressionTypes, (String)"Expression types must not be null or empty");
        boolean strict = part.shouldIgnoreCase() == Part.IgnoreCaseType.ALWAYS;
        for (Class<?> expressionType : expressionTypes) {
            if (this.canUpperCase(expressionType)) continue;
            if (strict) {
                throw new IllegalStateException("Unable to ignore case of " + expressionType.getName() + " type, the property '" + part.getProperty().getSegment() + "' must reference a string");
            }
            return false;
        }
        return true;
    }

    private boolean canUpperCase(Class<?> expressionType) {
        return expressionType == String.class;
    }

    private static Collection<Object> asCollection(Object value) {
        if (value instanceof Collection) {
            return (Collection)value;
        }
        if (value.getClass().isArray()) {
            return Arrays.asList(ObjectUtils.toObjectArray((Object)value));
        }
        return Collections.singletonList(value);
    }
}

