/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import org.jspecify.annotations.Nullable;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.DefaultDelete;
import org.springframework.data.relational.core.sql.Delete;
import org.springframework.data.relational.core.sql.DeleteBuilder;
import org.springframework.data.relational.core.sql.DeleteValidator;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.util.Assert;

class DefaultDeleteBuilder
implements DeleteBuilder,
DeleteBuilder.DeleteWhereAndOr,
DeleteBuilder.DeleteWhere {
    private @Nullable Table from;
    private @Nullable Condition where;

    DefaultDeleteBuilder() {
    }

    @Override
    public DeleteBuilder.DeleteWhere from(Table table) {
        Assert.notNull((Object)table, (String)"Table must not be null");
        this.from = table;
        return this;
    }

    @Override
    public DeleteBuilder.DeleteWhereAndOr where(Condition condition) {
        Assert.notNull((Object)condition, (String)"where must not be null");
        this.where = condition;
        return this;
    }

    @Override
    public DeleteBuilder.DeleteWhereAndOr and(Condition condition) {
        Assert.notNull((Object)condition, (String)"Condition must not be null");
        Assert.state((this.where != null ? 1 : 0) != 0, (String)"where must not be null");
        this.where = this.where.and(condition);
        return this;
    }

    @Override
    public DeleteBuilder.DeleteWhereAndOr or(Condition condition) {
        Assert.notNull((Object)condition, (String)"Condition must not be null");
        Assert.state((this.where != null ? 1 : 0) != 0, (String)"where must not be null");
        this.where = this.where.or(condition);
        return this;
    }

    @Override
    public Delete build() {
        Assert.state((this.from != null ? 1 : 0) != 0, (String)"from must not be null");
        DefaultDelete delete = new DefaultDelete(this.from, this.where);
        DeleteValidator.validate(delete);
        return delete;
    }
}

