/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.HashSet;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.data.relational.core.sql.From;
import org.springframework.data.relational.core.sql.Join;
import org.springframework.data.relational.core.sql.OrderByField;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.Visitor;
import org.springframework.data.relational.core.sql.Where;

abstract class AbstractImportValidator
implements Visitor {
    final Set<TableLike> requiredByWhere = new HashSet<TableLike>();
    final Set<TableLike> from = new HashSet<TableLike>();
    @Nullable Visitable parent;

    AbstractImportValidator() {
    }

    @Override
    public void enter(Visitable segment) {
        if (segment instanceof Table && this.parent instanceof From) {
            this.from.add((Table)segment);
        }
        if (segment instanceof Where) {
            segment.visit(new SubselectFilteringWhereVisitor());
        }
        if (segment instanceof Join || segment instanceof OrderByField || segment instanceof From || segment instanceof Select || segment instanceof Where || segment instanceof SimpleFunction) {
            this.parent = segment;
        }
    }

    @Override
    public void leave(Visitable segment) {
    }

    class SubselectFilteringWhereVisitor
    implements Visitor {
        private @Nullable Select selectFilter;

        SubselectFilteringWhereVisitor() {
        }

        @Override
        public void enter(Visitable segment) {
            if (this.selectFilter != null) {
                return;
            }
            if (segment instanceof Select) {
                this.selectFilter = (Select)segment;
                return;
            }
            if (segment instanceof Table) {
                AbstractImportValidator.this.requiredByWhere.add((Table)segment);
            }
        }

        @Override
        public void leave(Visitable segment) {
            if (this.selectFilter == segment) {
                this.selectFilter = null;
            }
        }
    }
}

