/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Delete;
import org.springframework.data.relational.core.sql.From;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Visitor;
import org.springframework.data.relational.core.sql.Where;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultDelete
implements Delete {
    private final From from;
    @Nullable
    private final Where where;

    DefaultDelete(Table table, @Nullable Condition where) {
        this.from = new From(table);
        this.where = where != null ? new Where(where) : null;
    }

    @Override
    public void visit(Visitor visitor) {
        Assert.notNull((Object)visitor, (String)"Visitor must not be null");
        visitor.enter(this);
        this.from.visit(visitor);
        if (this.where != null) {
            this.where.visit(visitor);
        }
        visitor.leave(this);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DELETE ").append(this.from);
        if (this.where != null) {
            builder.append(' ').append(this.where);
        }
        return builder.toString();
    }
}

