/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.query;

import java.util.Arrays;
import java.util.List;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface CriteriaDefinition {
    public static CriteriaDefinition empty() {
        return Criteria.EMPTY;
    }

    public static CriteriaDefinition from(CriteriaDefinition ... criteria) {
        Assert.notNull((Object)criteria, (String)"Criteria must not be null");
        Assert.noNullElements((Object[])criteria, (String)"Criteria must not contain null elements");
        return CriteriaDefinition.from(Arrays.asList(criteria));
    }

    public static CriteriaDefinition from(List<? extends CriteriaDefinition> criteria) {
        Assert.notNull(criteria, (String)"Criteria must not be null");
        Assert.noNullElements(criteria, (String)"Criteria must not contain null elements");
        if (criteria.isEmpty()) {
            return Criteria.EMPTY;
        }
        if (criteria.size() == 1) {
            return criteria.get(0);
        }
        return Criteria.EMPTY.and(criteria);
    }

    public boolean isGroup();

    public List<CriteriaDefinition> getGroup();

    @Nullable
    public SqlIdentifier getColumn();

    @Nullable
    public Comparator getComparator();

    @Nullable
    public Object getValue();

    public boolean isIgnoreCase();

    @Nullable
    public CriteriaDefinition getPrevious();

    public boolean hasPrevious();

    public boolean isEmpty();

    public Combinator getCombinator();

    public static enum Comparator {
        INITIAL(""),
        EQ("="),
        NEQ("!="),
        BETWEEN("BETWEEN"),
        NOT_BETWEEN("NOT BETWEEN"),
        LT("<"),
        LTE("<="),
        GT(">"),
        GTE(">="),
        IS_NULL("IS NULL"),
        IS_NOT_NULL("IS NOT NULL"),
        LIKE("LIKE"),
        NOT_LIKE("NOT LIKE"),
        NOT_IN("NOT IN"),
        IN("IN"),
        IS_TRUE("IS TRUE"),
        IS_FALSE("IS FALSE");

        private final String comparator;

        private Comparator(String comparator) {
            this.comparator = comparator;
        }

        public String getComparator() {
            return this.comparator;
        }
    }

    public static enum Combinator {
        INITIAL,
        AND,
        OR;

    }
}

