/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.BatchedActions;
import org.springframework.data.relational.core.conversion.BatchingAggregateChange;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.RootAggregateChange;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.util.Assert;

public class SaveBatchingAggregateChange<T>
implements BatchingAggregateChange<T, RootAggregateChange<T>> {
    private static final Comparator<PersistentPropertyPath<RelationalPersistentProperty>> pathLengthComparator = Comparator.comparing(PersistentPropertyPath::getLength);
    private final Class<T> entityType;
    private final List<DbAction<?>> rootActions = new ArrayList();
    private final List<DbAction.InsertRoot<T>> insertRootBatchCandidates = new ArrayList<DbAction.InsertRoot<T>>();
    private final BatchedActions insertActions = BatchedActions.batchedInserts();
    private final BatchedActions deleteActions = BatchedActions.batchedDeletes();

    SaveBatchingAggregateChange(Class<T> entityType) {
        this.entityType = entityType;
    }

    @Override
    public AggregateChange.Kind getKind() {
        return AggregateChange.Kind.SAVE;
    }

    @Override
    public Class<T> getEntityType() {
        return this.entityType;
    }

    @Override
    public void forEachAction(Consumer<? super DbAction<?>> consumer) {
        Assert.notNull(consumer, (String)"Consumer must not be null");
        this.rootActions.forEach(consumer);
        if (this.insertRootBatchCandidates.size() > 1) {
            consumer.accept(new DbAction.BatchInsertRoot<T>(this.insertRootBatchCandidates));
        } else {
            this.insertRootBatchCandidates.forEach(consumer);
        }
        this.deleteActions.forEach(consumer);
        this.insertActions.forEach(consumer);
    }

    @Override
    public void add(RootAggregateChange<T> aggregateChange) {
        aggregateChange.forEachAction(action -> {
            if (action instanceof DbAction.UpdateRoot) {
                DbAction.UpdateRoot rootAction = (DbAction.UpdateRoot)action;
                this.combineBatchCandidatesIntoSingleBatchRootAction();
                this.rootActions.add(rootAction);
            } else if (action instanceof DbAction.InsertRoot) {
                DbAction.InsertRoot rootAction = (DbAction.InsertRoot)action;
                if (!this.insertRootBatchCandidates.isEmpty() && !this.insertRootBatchCandidates.get(0).getIdValueSource().equals((Object)rootAction.getIdValueSource())) {
                    this.combineBatchCandidatesIntoSingleBatchRootAction();
                }
                this.insertRootBatchCandidates.add(rootAction);
            } else if (action instanceof DbAction.Insert) {
                DbAction.Insert insertAction = (DbAction.Insert)action;
                this.insertActions.add(insertAction);
            } else if (action instanceof DbAction.Delete) {
                DbAction.Delete deleteAction = (DbAction.Delete)action;
                this.deleteActions.add(deleteAction);
            }
        });
    }

    private void combineBatchCandidatesIntoSingleBatchRootAction() {
        if (this.insertRootBatchCandidates.size() > 1) {
            this.rootActions.add(new DbAction.BatchInsertRoot<T>(List.copyOf(this.insertRootBatchCandidates)));
        } else {
            this.rootActions.addAll(this.insertRootBatchCandidates);
        }
        this.insertRootBatchCandidates.clear();
    }
}

