/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import java.util.OptionalLong;
import java.util.function.Function;
import org.springframework.data.domain.Sort;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.dialect.OrderByNullPrecedence;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.data.relational.core.sql.LockOptions;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.render.SelectRenderContext;

public abstract class AbstractDialect
implements Dialect {
    @Override
    public SelectRenderContext getSelectContext() {
        Function<Select, CharSequence> afterFromTable = this.getAfterFromTable();
        Function<Select, CharSequence> afterOrderBy = this.getAfterOrderBy();
        return new DialectSelectRenderContext(afterFromTable, afterOrderBy, this.orderByNullHandling());
    }

    protected Function<Select, CharSequence> getAfterFromTable() {
        LockRenderFunction afterFromTable = select -> "";
        LockClause lockClause = this.lock();
        if (lockClause.getClausePosition() == LockClause.Position.AFTER_FROM_TABLE) {
            afterFromTable = new LockRenderFunction(lockClause);
        }
        return afterFromTable.andThen(PrependWithLeadingWhitespace.INSTANCE);
    }

    protected Function<Select, CharSequence> getAfterOrderBy() {
        Function<Select, ? extends CharSequence> afterOrderByLimit = this.getAfterOrderByLimit();
        Function<Select, ? extends CharSequence> afterOrderByLock = this.getAfterOrderByLock();
        return select -> String.valueOf(afterOrderByLimit.apply((Select)select)) + afterOrderByLock.apply((Select)select);
    }

    private Function<Select, ? extends CharSequence> getAfterOrderByLimit() {
        LimitClause limit = this.limit();
        if (limit.getClausePosition() == LimitClause.Position.AFTER_ORDER_BY) {
            return new AfterOrderByLimitRenderFunction(limit).andThen(PrependWithLeadingWhitespace.INSTANCE);
        }
        throw new UnsupportedOperationException(String.format("Clause position %s not supported!", limit));
    }

    private Function<Select, ? extends CharSequence> getAfterOrderByLock() {
        LockClause lock = this.lock();
        LockRenderFunction afterOrderByLock = select -> "";
        if (lock.getClausePosition() == LockClause.Position.AFTER_ORDER_BY) {
            afterOrderByLock = new LockRenderFunction(lock);
        }
        return afterOrderByLock.andThen(PrependWithLeadingWhitespace.INSTANCE);
    }

    static enum PrependWithLeadingWhitespace implements Function<CharSequence, CharSequence>
    {
        INSTANCE;


        @Override
        public CharSequence apply(CharSequence charSequence) {
            if (charSequence.length() == 0) {
                return charSequence;
            }
            return " " + charSequence;
        }
    }

    static class LockRenderFunction
    implements Function<Select, CharSequence> {
        private final LockClause clause;

        public LockRenderFunction(LockClause clause) {
            this.clause = clause;
        }

        @Override
        public CharSequence apply(Select select) {
            LockMode lockMode = select.getLockMode();
            if (lockMode == null) {
                return "";
            }
            return this.clause.getLock(new LockOptions(lockMode, select.getFrom()));
        }
    }

    static class AfterOrderByLimitRenderFunction
    implements Function<Select, CharSequence> {
        private final LimitClause clause;

        public AfterOrderByLimitRenderFunction(LimitClause clause) {
            this.clause = clause;
        }

        @Override
        public CharSequence apply(Select select) {
            OptionalLong limit = select.getLimit();
            OptionalLong offset = select.getOffset();
            if (limit.isPresent() && offset.isPresent()) {
                return this.clause.getLimitOffset(limit.getAsLong(), offset.getAsLong());
            }
            if (limit.isPresent()) {
                return this.clause.getLimit(limit.getAsLong());
            }
            if (offset.isPresent()) {
                return this.clause.getOffset(offset.getAsLong());
            }
            return "";
        }
    }

    static class DialectSelectRenderContext
    implements SelectRenderContext {
        private final Function<Select, ? extends CharSequence> afterFromTable;
        private final Function<Select, ? extends CharSequence> afterOrderBy;
        private final OrderByNullPrecedence orderByNullPrecedence;

        DialectSelectRenderContext(Function<Select, ? extends CharSequence> afterFromTable, Function<Select, ? extends CharSequence> afterOrderBy, OrderByNullPrecedence orderByNullPrecedence) {
            this.afterFromTable = afterFromTable;
            this.afterOrderBy = afterOrderBy;
            this.orderByNullPrecedence = orderByNullPrecedence;
        }

        @Override
        public Function<Select, ? extends CharSequence> afterFromTable() {
            return this.afterFromTable;
        }

        @Override
        public Function<Select, ? extends CharSequence> afterOrderBy(boolean hasOrderBy) {
            return this.afterOrderBy;
        }

        @Override
        public String evaluateOrderByNullHandling(Sort.NullHandling nullHandling) {
            return this.orderByNullPrecedence.evaluate(nullHandling);
        }
    }
}

