/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.AggregateChange;
import org.springframework.data.relational.core.conversion.DbAction;
import org.springframework.data.relational.core.conversion.MutableAggregateChange;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RelationalEntityDeleteWriter
implements EntityWriter<Object, MutableAggregateChange<?>> {
    private final RelationalMappingContext context;

    public RelationalEntityDeleteWriter(RelationalMappingContext context) {
        Assert.notNull((Object)((Object)context), (String)"Context must not be null");
        this.context = context;
    }

    public void write(@Nullable Object id, MutableAggregateChange<?> aggregateChange) {
        if (id == null) {
            this.deleteAll(aggregateChange.getEntityType()).forEach(aggregateChange::addAction);
        } else {
            this.deleteRoot(id, aggregateChange).forEach(aggregateChange::addAction);
        }
    }

    private List<DbAction<?>> deleteAll(Class<?> entityType) {
        ArrayList deleteReferencedActions = new ArrayList();
        this.context.findPersistentPropertyPaths(entityType, PersistentProperty::isEntity).filter(p -> !((RelationalPersistentProperty)p.getRequiredLeafProperty()).isEmbedded()).forEach(p -> deleteReferencedActions.add(new DbAction.DeleteAll((PersistentPropertyPath<RelationalPersistentProperty>)p)));
        Collections.reverse(deleteReferencedActions);
        ArrayList actions = new ArrayList();
        if (!deleteReferencedActions.isEmpty()) {
            actions.add(new DbAction.AcquireLockAllRoot(entityType));
        }
        actions.addAll(deleteReferencedActions);
        DbAction.DeleteAllRoot result = new DbAction.DeleteAllRoot(entityType);
        actions.add(result);
        return actions;
    }

    private <T> List<DbAction<?>> deleteRoot(Object id, MutableAggregateChange<T> aggregateChange) {
        List<DbAction<?>> deleteReferencedActions = this.deleteReferencedEntities(id, aggregateChange);
        ArrayList actions = new ArrayList();
        if (!deleteReferencedActions.isEmpty()) {
            actions.add(new DbAction.AcquireLockRoot(id, aggregateChange.getEntityType()));
        }
        actions.addAll(deleteReferencedActions);
        actions.add(new DbAction.DeleteRoot(id, aggregateChange.getEntityType(), aggregateChange.getPreviousVersion()));
        return actions;
    }

    private List<DbAction<?>> deleteReferencedEntities(Object id, AggregateChange<?> aggregateChange) {
        ArrayList actions = new ArrayList();
        this.context.findPersistentPropertyPaths(aggregateChange.getEntityType(), PersistentProperty::isEntity).filter(p -> !((RelationalPersistentProperty)p.getRequiredLeafProperty()).isEmbedded()).forEach(p -> actions.add(new DbAction.Delete(id, (PersistentPropertyPath<RelationalPersistentProperty>)p)));
        Collections.reverse(actions);
        return actions;
    }
}

