/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.hash;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.redis.hash.FlatEric;
import org.springframework.data.redis.hash.HashMapper;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.TreeNode;
import tools.jackson.core.Version;
import tools.jackson.databind.DefaultTyping;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.deser.Deserializers;
import tools.jackson.databind.deser.jdk.JavaUtilCalendarDeserializer;
import tools.jackson.databind.deser.jdk.JavaUtilDateDeserializer;
import tools.jackson.databind.deser.jdk.NumberDeserializers;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.exc.MismatchedInputException;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.jsontype.TypeResolverBuilder;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import tools.jackson.databind.jsontype.impl.DefaultTypeResolverBuilder;
import tools.jackson.databind.module.SimpleDeserializers;
import tools.jackson.databind.module.SimpleSerializers;
import tools.jackson.databind.ser.Serializers;
import tools.jackson.databind.ser.jdk.JavaUtilCalendarSerializer;
import tools.jackson.databind.ser.jdk.JavaUtilDateSerializer;

public class Jackson3HashMapper
implements HashMapper<Object, String, Object> {
    private static final Lazy<Jackson3HashMapper> sharedFlattening = Lazy.of(() -> Jackson3HashMapper.create(Jackson3HashMapperBuilder::flatten));
    private static final Lazy<Jackson3HashMapper> sharedHierarchical = Lazy.of(() -> Jackson3HashMapper.create(Jackson3HashMapperBuilder::hierarchical));
    private final ObjectMapper typingMapper;
    private final ObjectMapper untypedMapper;
    private final boolean flatten;

    public Jackson3HashMapper(ObjectMapper mapper, boolean flatten) {
        Assert.notNull((Object)mapper, (String)"Mapper must not be null");
        this.flatten = flatten;
        this.typingMapper = mapper;
        this.untypedMapper = JsonMapper.shared();
    }

    public static Jackson3HashMapper flattening() {
        return (Jackson3HashMapper)sharedFlattening.get();
    }

    public static Jackson3HashMapper hierarchical() {
        return (Jackson3HashMapper)sharedHierarchical.get();
    }

    public static Jackson3HashMapper create(Consumer<Jackson3HashMapperBuilder<JsonMapper.Builder>> configurer) {
        Assert.notNull(configurer, (String)"Builder configurer must not be null");
        Jackson3HashMapperBuilder<JsonMapper.Builder> builder = Jackson3HashMapper.builder();
        configurer.accept(builder);
        return builder.build();
    }

    public static Jackson3HashMapperBuilder<JsonMapper.Builder> builder() {
        return Jackson3HashMapper.builder(JsonMapper::builder);
    }

    public static <B extends MapperBuilder<? extends ObjectMapper, ? extends MapperBuilder<?, ?>>> Jackson3HashMapperBuilder<B> builder(Supplier<B> builderFactory) {
        Assert.notNull(builderFactory, (String)"MapperBuilder Factory must not be null");
        return new Jackson3HashMapperBuilder<B>(builderFactory);
    }

    public static void preconfigure(MapperBuilder<? extends ObjectMapper, ? extends MapperBuilder<?, ?>> builder, boolean jackson2Compatibility) {
        builder.findAndAddModules().addModules(new JacksonModule[]{new HashMapperModule(jackson2Compatibility)}).disable(new MapperFeature[]{MapperFeature.REQUIRE_TYPE_ID_FOR_SUBTYPES}).configure(DeserializationFeature.FAIL_ON_MISSING_EXTERNAL_TYPE_ID_PROPERTY, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).changeDefaultPropertyInclusion(value -> value.withValueInclusion(JsonInclude.Include.NON_NULL));
    }

    @Override
    public Map<String, Object> toHash(@Nullable Object source) {
        JsonNode tree = this.typingMapper.valueToTree(source);
        return this.flatten ? FlatEric.flatten(Jackson3AdapterFactory.INSTANCE, tree.properties()) : (Map)this.untypedMapper.convertValue((Object)tree, Map.class);
    }

    @Override
    public Object fromHash(Map<String, Object> hash) {
        try {
            if (this.flatten) {
                Map<String, Object> unflattenedHash = FlatEric.unflatten(hash);
                byte[] unflattenedHashedBytes = this.untypedMapper.writeValueAsBytes(unflattenedHash);
                Object hashedObject = this.typingMapper.reader().forType(Object.class).readValue(unflattenedHashedBytes);
                return hashedObject;
            }
            return this.typingMapper.treeToValue((TreeNode)this.untypedMapper.valueToTree(hash), Object.class);
        }
        catch (Exception ex) {
            throw new MappingException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static class Jackson3HashMapperBuilder<B extends MapperBuilder<? extends ObjectMapper, ? extends MapperBuilder<?, ?>>> {
        private final Supplier<B> builderFactory;
        private PolymorphicTypeValidator typeValidator = BasicPolymorphicTypeValidator.builder().allowIfBaseType(Object.class).allowIfSubType((ctx, clazz) -> true).build();
        private boolean jackson2CompatibilityMode = false;
        private boolean flatten = false;
        private Consumer<B> mapperBuilderCustomizer = builder -> {};

        private Jackson3HashMapperBuilder(Supplier<B> builderFactory) {
            this.builderFactory = builderFactory;
        }

        @Contract(value="-> this")
        public Jackson3HashMapperBuilder<B> flatten() {
            return this.flatten(true);
        }

        @Contract(value="-> this")
        public Jackson3HashMapperBuilder<B> hierarchical() {
            return this.flatten(false);
        }

        @Contract(value="_ -> this")
        public Jackson3HashMapperBuilder<B> flatten(boolean flatten) {
            this.flatten = flatten;
            return this;
        }

        @Contract(value="-> this")
        public Jackson3HashMapperBuilder<B> jackson2CompatibilityMode() {
            this.jackson2CompatibilityMode = true;
            return this;
        }

        @Contract(value="_ -> this")
        public Jackson3HashMapperBuilder<B> typeValidator(PolymorphicTypeValidator typeValidator) {
            Assert.notNull((Object)typeValidator, (String)"Type validator must not be null");
            this.typeValidator = typeValidator;
            return this;
        }

        @Contract(value="_ -> this")
        public Jackson3HashMapperBuilder<B> customize(Consumer<B> mapperBuilderCustomizer) {
            Assert.notNull(mapperBuilderCustomizer, (String)"JSON mapper customizer must not be null");
            this.mapperBuilderCustomizer = mapperBuilderCustomizer;
            return this;
        }

        @Contract(value="-> new")
        public Jackson3HashMapper build() {
            MapperBuilder mapperBuilder = (MapperBuilder)this.builderFactory.get();
            Jackson3HashMapper.preconfigure(mapperBuilder, this.jackson2CompatibilityMode);
            mapperBuilder.setDefaultTyping(Jackson3HashMapperBuilder.getDefaultTyping(this.typeValidator, this.flatten, "@class"));
            this.mapperBuilderCustomizer.accept(mapperBuilder);
            return new Jackson3HashMapper(mapperBuilder.build(), this.flatten);
        }

        private static TypeResolverBuilder<?> getDefaultTyping(PolymorphicTypeValidator typeValidator, final boolean flatten, String typePropertyName) {
            return new DefaultTypeResolverBuilder(typeValidator, DefaultTyping.NON_FINAL, typePropertyName){

                public boolean useForType(JavaType type) {
                    if (type.isPrimitive()) {
                        return false;
                    }
                    if (flatten && (type.isTypeOrSubTypeOf(Number.class) || type.isEnumType())) {
                        return false;
                    }
                    return !TreeNode.class.isAssignableFrom(type.getRawClass());
                }
            };
        }
    }

    private static class HashMapperModule
    extends JacksonModule {
        private final boolean useCalendarTimestamps;

        private HashMapperModule(boolean useCalendarTimestamps) {
            this.useCalendarTimestamps = useCalendarTimestamps;
        }

        public String getModuleName() {
            return "spring-data-redis-hash-mapper-module";
        }

        public Version version() {
            return new Version(4, 0, 0, null, "org.springframework.data", "spring-data-redis");
        }

        public void setupModule(JacksonModule.SetupContext context) {
            ArrayList<Object> valueSerializers = new ArrayList<Object>();
            valueSerializers.add(new JavaUtilDateSerializer(true, null){

                public void serializeWithType(Date value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
                    this.serialize(value, g, ctxt);
                }
            });
            valueSerializers.add((Object)new UTCCalendarSerializer(this.useCalendarTimestamps));
            SimpleSerializers serializers = new SimpleSerializers(valueSerializers);
            context.addSerializers((Serializers)serializers);
            LinkedHashMap valueDeserializers = new LinkedHashMap();
            valueDeserializers.put(Calendar.class, new UntypedFallbackDeserializer((StdDeserializer<?>)new UntypedUTCCalendarDeserializer()));
            valueDeserializers.put(Date.class, new UntypedFallbackDeserializer((StdDeserializer<?>)new JavaUtilDateDeserializer()));
            valueDeserializers.put(BigInteger.class, new UntypedFallbackDeserializer((StdDeserializer<?>)new NumberDeserializers.BigIntegerDeserializer()));
            valueDeserializers.put(BigDecimal.class, new UntypedFallbackDeserializer((StdDeserializer<?>)new NumberDeserializers.BigDecimalDeserializer()));
            context.addDeserializers((Deserializers)new SimpleDeserializers(valueDeserializers));
        }
    }

    private static enum Jackson3AdapterFactory implements FlatEric.JsonNodeAdapterFactory
    {
        INSTANCE;


        @Override
        public FlatEric.JsonNodeAdapter adapt(Object node) {
            FlatEric.JsonNodeAdapter jsonNodeAdapter;
            if (node instanceof FlatEric.JsonNodeAdapter) {
                FlatEric.JsonNodeAdapter na = (FlatEric.JsonNodeAdapter)node;
                jsonNodeAdapter = na;
            } else {
                jsonNodeAdapter = new Jackson3JsonNodeAdapter((JsonNode)node);
            }
            return jsonNodeAdapter;
        }

        @Override
        public boolean isJsonNode(Object value) {
            return value instanceof JsonNode || value instanceof FlatEric.JsonNodeAdapter;
        }
    }

    private record Jackson3JsonNodeAdapter(JsonNode node) implements FlatEric.JsonNodeAdapter
    {
        @Override
        public FlatEric.JsonNodeType getNodeType() {
            return FlatEric.JsonNodeType.valueOf(this.node().getNodeType().name());
        }

        @Override
        public boolean isArray() {
            return this.node().isArray();
        }

        @Override
        public Collection<? extends FlatEric.JsonNodeAdapter> values() {
            return this.node().valueStream().map(Jackson3JsonNodeAdapter::new).toList();
        }

        @Override
        public String asString() {
            return this.node().asString();
        }

        @Override
        public boolean isNumber() {
            return this.node().isNumber();
        }

        @Override
        public Number numberValue() {
            return this.node().numberValue();
        }

        @Override
        public boolean isString() {
            return this.node().isString();
        }

        @Override
        public String stringValue() {
            return this.node().stringValue();
        }

        @Override
        public boolean isBoolean() {
            return this.node().isBoolean();
        }

        @Override
        public boolean booleanValue() {
            return this.node().booleanValue();
        }

        @Override
        public boolean isBinary() {
            return this.node().isBinary();
        }

        @Override
        public byte[] binaryValue() {
            return this.node().binaryValue();
        }

        @Override
        public boolean isObject() {
            return this.node().isObject();
        }

        @Override
        public Collection<Map.Entry<String, FlatEric.JsonNodeAdapter>> properties() {
            return this.node().propertyStream().map(it -> Map.entry((String)it.getKey(), new Jackson3JsonNodeAdapter((JsonNode)it.getValue()))).toList();
        }

        @Override
        public @Nullable Object getDirectValue() {
            return new DirectFieldAccessFallbackBeanWrapper((Object)this.node()).getPropertyValue("_value");
        }
    }

    static class UntypedUTCCalendarDeserializer
    extends JavaUtilCalendarDeserializer {
        private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

        UntypedUTCCalendarDeserializer() {
        }

        public Calendar deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
            Calendar cal = super.deserialize(p, ctxt);
            Calendar utc = Calendar.getInstance(UTC);
            utc.setTimeInMillis(cal.getTimeInMillis());
            utc.setTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault()));
            return utc;
        }
    }

    static class UTCCalendarSerializer
    extends JavaUtilCalendarSerializer {
        private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
        public final boolean useTimestamps;

        public UTCCalendarSerializer(boolean useTimestamps) {
            this.useTimestamps = useTimestamps;
        }

        public void serialize(Calendar value, JsonGenerator g, SerializationContext provider) throws JacksonException {
            Calendar utc = Calendar.getInstance();
            utc.setTimeInMillis(value.getTimeInMillis());
            utc.setTimeZone(UTC);
            super.serialize(utc, g, provider);
        }

        public void serializeWithType(Calendar value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
            this.serialize(value, g, ctxt);
        }

        protected boolean _asTimestamp(SerializationContext serializers) {
            return this.useTimestamps;
        }
    }

    static class UntypedFallbackDeserializer<T>
    extends StdDeserializer<T> {
        private final StdDeserializer<?> delegate;

        protected UntypedFallbackDeserializer(StdDeserializer<?> delegate) {
            super(Object.class);
            this.delegate = delegate;
        }

        public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws JacksonException {
            if (!(typeDeserializer instanceof AsPropertyTypeDeserializer)) {
                return super.deserializeWithType(p, ctxt, typeDeserializer);
            }
            AsPropertyTypeDeserializer asPropertySerializer = (AsPropertyTypeDeserializer)typeDeserializer;
            try {
                return super.deserializeWithType(p, ctxt, typeDeserializer);
            }
            catch (MismatchedInputException e) {
                if (!asPropertySerializer.baseType().isTypeOrSuperTypeOf(this.delegate.handledType())) {
                    throw e;
                }
                return this.deserialize(p, ctxt);
            }
        }

        public T deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
            return (T)this.delegate.deserialize(p, ctxt);
        }
    }
}

