/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.util.Assert;

@NullUnmarked
public interface ListOperations<K, V> {
    public List<V> range(@NonNull K var1, long var2, long var4);

    public void trim(@NonNull K var1, long var2, long var4);

    public Long size(@NonNull K var1);

    public Long leftPush(@NonNull K var1, V var2);

    public Long leftPushAll(@NonNull K var1, V ... var2);

    public Long leftPushAll(@NonNull K var1, @NonNull Collection<V> var2);

    public Long leftPushIfPresent(@NonNull K var1, V var2);

    public Long leftPush(@NonNull K var1, @NonNull V var2, V var3);

    public Long rightPush(@NonNull K var1, V var2);

    public Long rightPushAll(@NonNull K var1, V ... var2);

    public Long rightPushAll(@NonNull K var1, @NonNull Collection<V> var2);

    public Long rightPushIfPresent(@NonNull K var1, V var2);

    public Long rightPush(@NonNull K var1, @NonNull V var2, V var3);

    default public V move(@NonNull MoveFrom<K> from, @NonNull MoveTo<K> to) {
        Assert.notNull(from, (String)"Move from must not be null");
        Assert.notNull(to, (String)"Move to must not be null");
        return this.move(from.key, from.direction, to.key, to.direction);
    }

    public V move(@NonNull K var1,  @NonNull RedisListCommands.Direction var2, @NonNull K var3,  @NonNull RedisListCommands.Direction var4);

    default public V move(@NonNull MoveFrom<K> from, @NonNull MoveTo<K> to, @NonNull Duration timeout) {
        Assert.notNull(from, (String)"Move from must not be null");
        Assert.notNull(to, (String)"Move to must not be null");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.move(from.key, from.direction, to.key, to.direction, TimeoutUtils.toMillis(timeout.toMillis(), TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    default public V move(@NonNull K sourceKey,  @NonNull RedisListCommands.Direction from, @NonNull K destinationKey,  @NonNull RedisListCommands.Direction to, @NonNull Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.move(sourceKey, from, destinationKey, to, TimeoutUtils.toMillis(timeout.toMillis(), TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    public V move(@NonNull K var1,  @NonNull RedisListCommands.Direction var2, @NonNull K var3,  @NonNull RedisListCommands.Direction var4, long var5, @NonNull TimeUnit var7);

    public void set(@NonNull K var1, long var2, V var4);

    public Long remove(@NonNull K var1, long var2, Object var4);

    default public V getFirst(@NonNull K key) {
        return this.index(key, 0L);
    }

    default public V getLast(@NonNull K key) {
        return this.index(key, -1L);
    }

    public V index(@NonNull K var1, long var2);

    public Long indexOf(@NonNull K var1, V var2);

    public Long lastIndexOf(@NonNull K var1, V var2);

    public V leftPop(@NonNull K var1);

    public List<V> leftPop(@NonNull K var1, long var2);

    public V leftPop(@NonNull K var1, long var2, @NonNull TimeUnit var4);

    default public V leftPop(@NonNull K key, @NonNull Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.leftPop(key, TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    public V rightPop(@NonNull K var1);

    public List<V> rightPop(@NonNull K var1, long var2);

    public V rightPop(@NonNull K var1, long var2, @NonNull TimeUnit var4);

    default public V rightPop(@NonNull K key, @NonNull Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.rightPop(key, TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    public V rightPopAndLeftPush(@NonNull K var1, @NonNull K var2);

    public V rightPopAndLeftPush(@NonNull K var1, @NonNull K var2, long var3, @NonNull TimeUnit var5);

    default public V rightPopAndLeftPush(@NonNull K sourceKey, @NonNull K destinationKey, @NonNull Duration timeout) {
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
        Assert.isTrue((!timeout.isNegative() ? 1 : 0) != 0, (String)"Timeout must not be negative");
        return this.rightPopAndLeftPush(sourceKey, destinationKey, TimeoutUtils.toSeconds(timeout), TimeUnit.SECONDS);
    }

    public @NonNull RedisOperations<K, V> getOperations();

    @NullMarked
    public static class MoveFrom<K> {
        final K key;
        final RedisListCommands.Direction direction;

        MoveFrom(K key, RedisListCommands.Direction direction) {
            this.key = key;
            this.direction = direction;
        }

        public static <K> MoveFrom<K> fromHead(K key) {
            return new MoveFrom<K>(key, RedisListCommands.Direction.first());
        }

        public static <K> MoveFrom<K> fromTail(K key) {
            return new MoveFrom<K>(key, RedisListCommands.Direction.last());
        }
    }

    @NullMarked
    public static class MoveTo<K> {
        final K key;
        final RedisListCommands.Direction direction;

        MoveTo(K key, RedisListCommands.Direction direction) {
            this.key = key;
            this.direction = direction;
        }

        public static <K> MoveTo<K> toHead(K key) {
            return new MoveTo<K>(key, RedisListCommands.Direction.first());
        }

        public static <K> MoveTo<K> toTail(K key) {
            return new MoveTo<K>(key, RedisListCommands.Direction.last());
        }
    }
}

