/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.BoundKeyOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.domain.geo.BoundingBox;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;

@NullUnmarked
public interface BoundGeoOperations<K, M>
extends BoundKeyOperations<K> {
    public Long add(@NonNull Point var1, @NonNull M var2);

    public Long add( @NonNull RedisGeoCommands.GeoLocation<M> var1);

    public Long add(@NonNull Map<@NonNull M, @NonNull Point> var1);

    public Long add(@NonNull Iterable< @NonNull RedisGeoCommands.GeoLocation<M>> var1);

    public Distance distance(@NonNull M var1, @NonNull M var2);

    public Distance distance(@NonNull M var1, @NonNull M var2, @NonNull Metric var3);

    public List<String> hash(M ... var1);

    public List<Point> position(M ... var1);

    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(@NonNull Circle var1);

    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(@NonNull Circle var1,  @NonNull RedisGeoCommands.GeoRadiusCommandArgs var2);

    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(@NonNull M var1, double var2);

    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(@NonNull M var1, @NonNull Distance var2);

    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(@NonNull M var1, @NonNull Distance var2,  @NonNull RedisGeoCommands.GeoRadiusCommandArgs var3);

    public Long remove(M ... var1);

    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(@NonNull Circle within) {
        return this.search(GeoReference.fromCircle(within), GeoShape.byRadius(within.getRadius()), RedisGeoCommands.GeoSearchCommandArgs.newGeoSearchArgs());
    }

    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(@NonNull GeoReference<M> reference, @NonNull Distance radius) {
        return this.search(reference, radius, RedisGeoCommands.GeoSearchCommandArgs.newGeoSearchArgs());
    }

    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(@NonNull GeoReference<M> reference, @NonNull Distance radius,  @NonNull RedisGeoCommands.GeoSearchCommandArgs args) {
        return this.search(reference, GeoShape.byRadius(radius), args);
    }

    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(@NonNull GeoReference<M> reference, @NonNull BoundingBox boundingBox) {
        return this.search(reference, boundingBox, RedisGeoCommands.GeoSearchCommandArgs.newGeoSearchArgs());
    }

    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(@NonNull GeoReference<M> reference, @NonNull BoundingBox boundingBox,  @NonNull RedisGeoCommands.GeoSearchCommandArgs args) {
        return this.search(reference, GeoShape.byBox(boundingBox), args);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<M>> search(@NonNull GeoReference<M> var1, @NonNull GeoShape var2,  @NonNull RedisGeoCommands.GeoSearchCommandArgs var3);

    default public Long searchAndStore(@NonNull K destKey, @NonNull Circle within) {
        return this.searchAndStore(destKey, GeoReference.fromCircle(within), GeoShape.byRadius(within.getRadius()), RedisGeoCommands.GeoSearchStoreCommandArgs.newGeoSearchStoreArgs());
    }

    default public Long searchAndStore(@NonNull K destKey, @NonNull GeoReference<M> reference, @NonNull Distance radius) {
        return this.searchAndStore(destKey, reference, radius, RedisGeoCommands.GeoSearchStoreCommandArgs.newGeoSearchStoreArgs());
    }

    default public Long searchAndStore(@NonNull K destKey, @NonNull GeoReference<M> reference, @NonNull Distance radius,  @NonNull RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        return this.searchAndStore(destKey, reference, GeoShape.byRadius(radius), args);
    }

    default public Long searchAndStore(@NonNull K destKey, @NonNull GeoReference<M> reference, @NonNull BoundingBox boundingBox) {
        return this.searchAndStore(destKey, reference, boundingBox, RedisGeoCommands.GeoSearchStoreCommandArgs.newGeoSearchStoreArgs());
    }

    default public Long searchAndStore(@NonNull K destKey, @NonNull GeoReference<M> reference, @NonNull BoundingBox boundingBox, RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        return this.searchAndStore(destKey, reference, GeoShape.byBox(boundingBox), args);
    }

    public Long searchAndStore(@NonNull K var1, @NonNull GeoReference<M> var2, @NonNull GeoShape var3,  @NonNull RedisGeoCommands.GeoSearchStoreCommandArgs var4);

    @Override
    public RedisOperations<K, ?> getOperations();
}

