/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.stream;

import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Consumer {
    private final String group;
    private final String name;

    private Consumer(String group, String name) {
        this.group = group;
        this.name = name;
    }

    public static Consumer from(String group, String name) {
        Assert.hasText((String)group, (String)"Group must not be null");
        Assert.hasText((String)name, (String)"Name must not be null");
        return new Consumer(group, name);
    }

    public String toString() {
        return "%s:%s".formatted(this.group, this.name);
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Consumer consumer = (Consumer)o;
        if (!ObjectUtils.nullSafeEquals((Object)this.group, (Object)consumer.group)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.name, (Object)consumer.name);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.group);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.name);
        return result;
    }
}

