/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.BitFieldArgs;
import io.lettuce.core.api.async.RedisStringAsyncCommands;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.Assert;

@NullUnmarked
class LettuceStringCommands
implements RedisStringCommands {
    private final LettuceConnection connection;

    LettuceStringCommands(@NonNull LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public byte[] get(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (byte[])this.connection.invoke().just(RedisStringAsyncCommands::get, key);
    }

    @Override
    public byte[] getDel(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (byte[])this.connection.invoke().just(RedisStringAsyncCommands::getdel, key);
    }

    @Override
    public byte[] getEx(byte @NonNull [] key, @NonNull Expiration expiration) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)expiration, (String)"Expiration must not be null");
        return (byte[])this.connection.invoke().just(RedisStringAsyncCommands::getex, key, LettuceConverters.toGetExArgs(expiration));
    }

    @Override
    public byte[] getSet(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return (byte[])this.connection.invoke().just(RedisStringAsyncCommands::getset, key, value);
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return this.connection.invoke().fromMany(RedisStringAsyncCommands::mget, keys).toList(source -> (byte[])source.getValueOrElse(null));
    }

    @Override
    public Boolean set(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().from(RedisStringAsyncCommands::set, key, value).get(Converters.stringToBooleanConverter());
    }

    @Override
    public Boolean set(byte @NonNull [] key, byte @NonNull [] value, @NonNull Expiration expiration, @NonNull RedisStringCommands.SetOption option) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        Assert.notNull((Object)expiration, (String)"Expiration must not be null");
        Assert.notNull((Object)((Object)option), (String)"Option must not be null");
        return this.connection.invoke().from(RedisStringAsyncCommands::set, key, value, LettuceConverters.toSetArgs(expiration, option)).orElse(LettuceConverters.stringToBooleanConverter(), false);
    }

    @Override
    public byte @Nullable [] setGet(byte @NonNull [] key, byte @NonNull [] value, @NonNull Expiration expiration, @NonNull RedisStringCommands.SetOption option) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        Assert.notNull((Object)expiration, (String)"Expiration must not be null");
        Assert.notNull((Object)((Object)option), (String)"Option must not be null");
        return (byte[])this.connection.invoke().just(RedisStringAsyncCommands::setGet, key, value, LettuceConverters.toSetArgs(expiration, option));
    }

    @Override
    public Boolean setNX(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return (Boolean)this.connection.invoke().just(RedisStringAsyncCommands::setnx, key, value);
    }

    @Override
    public Boolean setEx(byte @NonNull [] key, long seconds, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().from(RedisStringAsyncCommands::setex, key, seconds, value).get(Converters.stringToBooleanConverter());
    }

    @Override
    public Boolean pSetEx(byte @NonNull [] key, long milliseconds, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().from(RedisStringAsyncCommands::psetex, key, milliseconds, value).get(Converters.stringToBooleanConverter());
    }

    @Override
    public Boolean mSet(@NonNull Map<byte @NonNull [], byte @NonNull []> tuples) {
        Assert.notNull(tuples, (String)"Tuples must not be null");
        return this.connection.invoke().from(RedisStringAsyncCommands::mset, tuples).get(Converters.stringToBooleanConverter());
    }

    @Override
    public Boolean mSetNX(@NonNull Map<byte @NonNull [], byte @NonNull []> tuples) {
        Assert.notNull(tuples, (String)"Tuples must not be null");
        return (Boolean)this.connection.invoke().just(RedisStringAsyncCommands::msetnx, tuples);
    }

    @Override
    public Long incr(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Long)this.connection.invoke().just(RedisStringAsyncCommands::incr, key);
    }

    @Override
    public Long incrBy(byte @NonNull [] key, long value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Long)this.connection.invoke().just(RedisStringAsyncCommands::incrby, key, value);
    }

    @Override
    public Double incrBy(byte @NonNull [] key, double value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Double)this.connection.invoke().just(RedisStringAsyncCommands::incrbyfloat, key, value);
    }

    @Override
    public Long decr(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Long)this.connection.invoke().just(RedisStringAsyncCommands::decr, key);
    }

    @Override
    public Long decrBy(byte @NonNull [] key, long value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Long)this.connection.invoke().just(RedisStringAsyncCommands::decrby, key, value);
    }

    @Override
    public Long append(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return (Long)this.connection.invoke().just(RedisStringAsyncCommands::append, key, value);
    }

    @Override
    public byte[] getRange(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (byte[])this.connection.invoke().just(RedisStringAsyncCommands::getrange, key, start, end);
    }

    @Override
    public void setRange(byte @NonNull [] key, byte @NonNull [] value, long offset) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        this.connection.invokeStatus().just(RedisStringAsyncCommands::setrange, key, offset, value);
    }

    @Override
    public Boolean getBit(byte @NonNull [] key, long offset) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().from(RedisStringAsyncCommands::getbit, key, offset).get(LettuceConverters.longToBoolean());
    }

    @Override
    public Boolean setBit(byte @NonNull [] key, long offset, boolean value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().from(RedisStringAsyncCommands::setbit, key, offset, LettuceConverters.toInt(value)).get(LettuceConverters.longToBoolean());
    }

    @Override
    public Long bitCount(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Long)this.connection.invoke().just(RedisStringAsyncCommands::bitcount, key);
    }

    @Override
    public Long bitCount(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Long)this.connection.invoke().just(RedisStringAsyncCommands::bitcount, key, start, end);
    }

    @Override
    public List<Long> bitField(byte @NonNull [] key, @NonNull BitFieldSubCommands subCommands) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)subCommands, (String)"Command must not be null");
        BitFieldArgs args = LettuceConverters.toBitFieldArgs(subCommands);
        return (List)this.connection.invoke().just(RedisStringAsyncCommands::bitfield, key, args);
    }

    @Override
    public Long bitOp(@NonNull RedisStringCommands.BitOperation op, byte @NonNull [] destination, byte[] ... keys) {
        Assert.notNull((Object)((Object)op), (String)"BitOperation must not be null");
        Assert.notNull((Object)destination, (String)"Destination key must not be null");
        if (op == RedisStringCommands.BitOperation.NOT && keys.length > 1) {
            throw new IllegalArgumentException("Bitop NOT should only be performed against one key");
        }
        return (Long)this.connection.invoke().just(it -> switch (op) {
            default -> throw new IncompatibleClassChangeError();
            case RedisStringCommands.BitOperation.AND -> it.bitopAnd((Object)destination, (Object[])keys);
            case RedisStringCommands.BitOperation.OR -> it.bitopOr((Object)destination, (Object[])keys);
            case RedisStringCommands.BitOperation.XOR -> it.bitopXor((Object)destination, (Object[])keys);
            case RedisStringCommands.BitOperation.NOT -> {
                if (keys.length != 1) {
                    throw new IllegalArgumentException("Bitop NOT should only be performed against one key");
                }
                yield it.bitopNot((Object)destination, (Object)keys[0]);
            }
        });
    }

    @Override
    public Long bitPos(byte @NonNull [] key, boolean bit, @NonNull Range<Long> range) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(range, (String)"Range must not be null Use Range.unbounded() instead");
        if (range.getLowerBound().isBounded()) {
            if (range.getUpperBound().isBounded()) {
                return (Long)this.connection.invoke().just(RedisStringAsyncCommands::bitpos, key, bit, LettuceStringCommands.getLowerValue(range), LettuceStringCommands.getUpperValue(range));
            }
            return (Long)this.connection.invoke().just(RedisStringAsyncCommands::bitpos, key, bit, LettuceStringCommands.getLowerValue(range));
        }
        return (Long)this.connection.invoke().just(RedisStringAsyncCommands::bitpos, key, bit);
    }

    @Override
    public Long strLen(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Long)this.connection.invoke().just(RedisStringAsyncCommands::strlen, key);
    }

    private static <T extends Comparable<T>> T getUpperValue(Range<T> range) {
        return (T)((Comparable)range.getUpperBound().getValue().orElseThrow(() -> new IllegalArgumentException("Range does not contain upper bound value")));
    }

    private static <T extends Comparable<T>> T getLowerValue(Range<T> range) {
        return (T)((Comparable)range.getLowerBound().getValue().orElseThrow(() -> new IllegalArgumentException("Range does not contain lower bound value")));
    }
}

